/*
 * Decompiled with CFR 0.152.
 */
package scouter.lang.step;

import java.io.IOException;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.step.Step;
import scouter.lang.step.StepSingle;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.util.DateUtil;
import scouter.util.IPUtil;

public class CommonSpanStep
extends StepSingle {
    public String nameDebug;
    public int hash;
    public int elapsed;
    public int error;
    public long timestamp;
    public byte spanType;
    public int localEndpointServiceName;
    public byte[] localEndpointIp;
    public short localEndpointPort;
    public int remoteEndpointServiceName;
    public byte[] remoteEndpointIp;
    public short remoteEndpointPort;
    public boolean debug;
    public boolean shared;
    public ListValue annotationTimestamps;
    public ListValue annotationValues;
    public MapValue tags;

    @Override
    public byte getStepType() {
        return 51;
    }

    @Override
    public void write(DataOutputX out) throws IOException {
        super.write(out);
        out.writeDecimal(this.hash);
        out.writeDecimal(this.elapsed);
        out.writeDecimal(this.error);
        out.writeDecimal(this.timestamp);
        out.writeByte(this.spanType);
        out.writeDecimal(this.localEndpointServiceName);
        out.writeBlob(this.localEndpointIp);
        out.writeShort(this.localEndpointPort);
        out.writeDecimal(this.remoteEndpointServiceName);
        out.writeBlob(this.remoteEndpointIp);
        out.writeShort(this.remoteEndpointPort);
        out.writeBoolean(this.debug);
        out.writeBoolean(this.shared);
        out.writeValue(this.annotationTimestamps);
        out.writeValue(this.annotationValues);
        out.writeValue(this.tags);
    }

    @Override
    public Step read(DataInputX in) throws IOException {
        super.read(in);
        this.hash = (int)in.readDecimal();
        this.elapsed = (int)in.readDecimal();
        this.error = (int)in.readDecimal();
        this.timestamp = in.readDecimal();
        this.spanType = in.readByte();
        this.localEndpointServiceName = (int)in.readDecimal();
        this.localEndpointIp = in.readBlob();
        this.localEndpointPort = in.readShort();
        this.remoteEndpointServiceName = (int)in.readDecimal();
        this.remoteEndpointIp = in.readBlob();
        this.remoteEndpointPort = in.readShort();
        this.debug = in.readBoolean();
        this.shared = in.readBoolean();
        this.annotationTimestamps = (ListValue)in.readValue();
        this.annotationValues = (ListValue)in.readValue();
        this.tags = (MapValue)in.readValue();
        return this;
    }

    public int getHash() {
        return this.hash;
    }

    public void setHash(int hash) {
        this.hash = hash;
    }

    public int getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(int elapsed) {
        this.elapsed = elapsed;
    }

    public int getError() {
        return this.error;
    }

    public void setError(int error) {
        this.error = error;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public byte getSpanType() {
        return this.spanType;
    }

    public void setSpanType(byte spanType) {
        this.spanType = spanType;
    }

    public int getLocalEndpointServiceName() {
        return this.localEndpointServiceName;
    }

    public void setLocalEndpointServiceName(int localEndpointServiceName) {
        this.localEndpointServiceName = localEndpointServiceName;
    }

    public byte[] getLocalEndpointIp() {
        return this.localEndpointIp;
    }

    public void setLocalEndpointIp(byte[] localEndpointIp) {
        this.localEndpointIp = localEndpointIp;
    }

    public short getLocalEndpointPort() {
        return this.localEndpointPort;
    }

    public void setLocalEndpointPort(short localEndpointPort) {
        this.localEndpointPort = localEndpointPort;
    }

    public int getRemoteEndpointServiceName() {
        return this.remoteEndpointServiceName;
    }

    public void setRemoteEndpointServiceName(int remoteEndpointServiceName) {
        this.remoteEndpointServiceName = remoteEndpointServiceName;
    }

    public byte[] getRemoteEndpointIp() {
        return this.remoteEndpointIp;
    }

    public void setRemoteEndpointIp(byte[] remoteEndpointIp) {
        this.remoteEndpointIp = remoteEndpointIp;
    }

    public short getRemoteEndpointPort() {
        return this.remoteEndpointPort;
    }

    public void setRemoteEndpointPort(short remoteEndpointPort) {
        this.remoteEndpointPort = remoteEndpointPort;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public ListValue getAnnotationTimestamps() {
        return this.annotationTimestamps;
    }

    public void setAnnotationTimestamps(ListValue annotationTimestamps) {
        this.annotationTimestamps = annotationTimestamps;
    }

    public ListValue getAnnotationValues() {
        return this.annotationValues;
    }

    public void setAnnotationValues(ListValue annotationValues) {
        this.annotationValues = annotationValues;
    }

    public MapValue getTags() {
        return this.tags;
    }

    public void setTags(MapValue tags) {
        this.tags = tags;
    }

    public String toString() {
        return "CommonSpanStep{nameDebug='" + this.nameDebug + '\'' + ", hash=" + this.hash + ", parent=" + this.parent + ", index=" + this.index + ", start_time=" + this.start_time + ", elapsed=" + this.elapsed + ", error=" + this.error + ", timestamp=" + this.timestamp + ", timestampDt=" + DateUtil.timestamp(this.timestamp / 1000L) + ", spanType=" + this.spanType + ", localEndpointServiceName=" + this.localEndpointServiceName + ", localEndpointIp=" + IPUtil.toString(this.localEndpointIp) + ", localEndpointPort=" + this.localEndpointPort + ", remoteEndpointServiceName=" + this.remoteEndpointServiceName + ", remoteEndpointIp=" + IPUtil.toString(this.remoteEndpointIp) + ", remoteEndpointPort=" + this.remoteEndpointPort + ", debug=" + this.debug + ", shared=" + this.shared + ", annotationTimestamps=" + this.annotationTimestamps + ", annotationValues=" + this.annotationValues + ", tags=" + this.tags + "}";
    }
}

