/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import scouter.util.CompareUtil;
import scouter.util.LongEnumer;

public class LongLinkedSet {
    private static final int DEFAULT_CAPACITY = 101;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private LongLinkedSetry[] table;
    private LongLinkedSetry header;
    private int count;
    private int threshold;
    private float loadFactor;
    private long NONE = 0L;
    private int max;

    public LongLinkedSet(int initCapacity, float loadFactor) {
        if (initCapacity < 0) {
            throw new RuntimeException("Capacity Error: " + initCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new RuntimeException("Load Count Error: " + loadFactor);
        }
        if (initCapacity == 0) {
            initCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new LongLinkedSetry[initCapacity];
        this.header.link_next = this.header.link_prev = (this.header = new LongLinkedSetry(0L, null));
        this.threshold = (int)((float)initCapacity * loadFactor);
    }

    public LongLinkedSet() {
        this(101, 0.75f);
    }

    public LongLinkedSet setNullValue(long none) {
        this.NONE = none;
        return this;
    }

    public int size() {
        return this.count;
    }

    public long[] getArray() {
        long[] _keys = new long[this.size()];
        LongEnumer en = this.elements();
        for (int i = 0; i < _keys.length; ++i) {
            _keys[i] = en.nextLong();
        }
        return _keys;
    }

    public synchronized LongEnumer elements() {
        return new Enumer();
    }

    public synchronized boolean contains(long key) {
        LongLinkedSetry[] buk = this.table;
        int index = this.hash(key) % buk.length;
        LongLinkedSetry e = buk[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized long getFirst() {
        return this.header.link_next.key;
    }

    public synchronized long getLast() {
        return this.header.link_prev.key;
    }

    private int hash(long key) {
        return (int)key & Integer.MAX_VALUE;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        LongLinkedSetry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        LongLinkedSetry[] newMap = new LongLinkedSetry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            LongLinkedSetry old = oldMap[i];
            while (old != null) {
                LongLinkedSetry e = old;
                old = old.next;
                long key = e.key;
                int index = this.hash(key) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public LongLinkedSet setMax(int max) {
        this.max = max;
        return this;
    }

    public long put(long key) {
        return this._put(key, MODE.LAST);
    }

    public long putLast(long key) {
        return this._put(key, MODE.FORCE_LAST);
    }

    public long putFirst(long key) {
        return this._put(key, MODE.FORCE_FIRST);
    }

    private synchronized long _put(long key, MODE m) {
        LongLinkedSetry[] buk = this.table;
        int index = this.hash(key) % buk.length;
        LongLinkedSetry e = buk[index];
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                switch (m) {
                    case FORCE_FIRST: {
                        if (this.header.link_next == e) break;
                        this.unchain(e);
                        this.chain(this.header, this.header.link_next, e);
                        break;
                    }
                    case FORCE_LAST: {
                        if (this.header.link_prev == e) break;
                        this.unchain(e);
                        this.chain(this.header.link_prev, this.header, e);
                    }
                }
                return key;
            }
            e = e.next;
        }
        if (this.max > 0) {
            switch (m) {
                case FORCE_FIRST: 
                case FIRST: {
                    while (this.count >= this.max) {
                        long v = this.header.link_prev.key;
                        this.remove(v);
                        this.overflowed(v);
                    }
                    break;
                }
                case FORCE_LAST: 
                case LAST: {
                    while (this.count >= this.max) {
                        long v = this.header.link_next.key;
                        this.remove(v);
                        this.overflowed(v);
                    }
                    break;
                }
            }
        }
        if (this.count >= this.threshold) {
            this.rehash();
            buk = this.table;
            index = this.hash(key) % buk.length;
        }
        buk[index] = e = new LongLinkedSetry(key, buk[index]);
        switch (m) {
            case FORCE_FIRST: 
            case FIRST: {
                this.chain(this.header, this.header.link_next, e);
                break;
            }
            case FORCE_LAST: 
            case LAST: {
                this.chain(this.header.link_prev, this.header, e);
            }
        }
        ++this.count;
        return this.NONE;
    }

    protected void overflowed(long value) {
    }

    public synchronized long remove(long key) {
        LongLinkedSetry[] buk = this.table;
        int index = this.hash(key) % buk.length;
        LongLinkedSetry e = buk[index];
        LongLinkedSetry prev = null;
        while (e != null) {
            if (CompareUtil.equals(e.key, key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    buk[index] = e.next;
                }
                --this.count;
                this.unchain(e);
                return key;
            }
            prev = e;
            e = e.next;
        }
        return this.NONE;
    }

    public synchronized long removeFirst() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.remove(this.header.link_next.key);
    }

    public synchronized long removeLast() {
        if (this.isEmpty()) {
            return this.NONE;
        }
        return this.remove(this.header.link_prev.key);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public synchronized void clear() {
        LongLinkedSetry[] buk = this.table;
        int index = buk.length;
        while (--index >= 0) {
            buk[index] = null;
        }
        this.header.link_next = this.header.link_prev = this.header;
        this.count = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        LongEnumer it = this.elements();
        buf.append("{");
        while (it.hasMoreElements()) {
            if (buf.length() > 1) {
                buf.append(",");
            }
            buf.append(it.nextLong());
        }
        buf.append("}");
        return buf.toString();
    }

    private void chain(LongLinkedSetry link_prev, LongLinkedSetry link_next, LongLinkedSetry e) {
        e.link_prev = link_prev;
        e.link_next = link_next;
        link_prev.link_next = e;
        link_next.link_prev = e;
    }

    private void unchain(LongLinkedSetry e) {
        e.link_prev.link_next = e.link_next;
        e.link_next.link_prev = e.link_prev;
        e.link_prev = null;
        e.link_next = null;
    }

    public synchronized void sort(boolean asc) {
        if (this.size() <= 1) {
            return;
        }
        long[] list = new long[this.size()];
        LongEnumer en = this.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            list[i] = en.nextLong();
            ++i;
        }
        Arrays.sort(list);
        this.clear();
        if (asc) {
            for (long n : list) {
                this.put(n);
            }
        } else {
            for (i = list.length - 1; i >= 0; --i) {
                this.put(list[i]);
            }
        }
    }

    public static void main(String[] args) {
        LongLinkedSet s = new LongLinkedSet();
        s.put(10L);
        s.put(20L);
        System.out.println(s);
        s.sort(false);
        System.out.println(s);
    }

    public static class LongLinkedSetry {
        long key;
        LongLinkedSetry next;
        LongLinkedSetry link_next;
        LongLinkedSetry link_prev;

        protected LongLinkedSetry(long key, LongLinkedSetry next) {
            this.key = key;
            this.next = next;
        }

        protected Object clone() {
            return new LongLinkedSetry(this.key, this.next == null ? null : (LongLinkedSetry)this.next.clone());
        }

        public long getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LongLinkedSetry)) {
                return false;
            }
            LongLinkedSetry e = (LongLinkedSetry)o;
            return CompareUtil.equals(e.key, this.key);
        }

        public int hashCode() {
            return (int)this.key;
        }

        public String toString() {
            return Long.toString(this.key);
        }
    }

    private class Enumer
    implements LongEnumer {
        LongLinkedSetry entry;

        private Enumer() {
            this.entry = ((LongLinkedSet)LongLinkedSet.this).header.link_next;
        }

        @Override
        public boolean hasMoreElements() {
            return LongLinkedSet.this.header != this.entry && this.entry != null;
        }

        @Override
        public long nextLong() {
            if (this.hasMoreElements()) {
                LongLinkedSetry e = this.entry;
                this.entry = e.link_next;
                return e.key;
            }
            throw new NoSuchElementException("no more next");
        }
    }

    private static enum MODE {
        FORCE_FIRST,
        FORCE_LAST,
        FIRST,
        LAST;

    }
}

