/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.alter;

import java.util.List;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class Alter
implements Statement {
    private Table table;
    private String columnName;
    private ColDataType dataType;
    private List<String> pkColumns;
    private List<String> ukColumns;
    private String ukName;

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public ColDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(ColDataType dataType) {
        this.dataType = dataType;
    }

    public List<String> getPkColumns() {
        return this.pkColumns;
    }

    public void setPkColumns(List<String> pkColumns) {
        this.pkColumns = pkColumns;
    }

    public List<String> getUkColumns() {
        return this.ukColumns;
    }

    public void setUkColumns(List<String> ukColumns) {
        this.ukColumns = ukColumns;
    }

    public String getUkName() {
        return this.ukName;
    }

    public void setUkName(String ukName) {
        this.ukName = ukName;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ALTER TABLE ").append(this.table.getFullyQualifiedName()).append(" ADD ");
        if (this.columnName != null) {
            b.append("COLUMN ").append(this.columnName).append(" ").append(this.dataType.toString());
        } else if (this.pkColumns != null) {
            b.append("PRIMARY KEY (").append(PlainSelect.getStringList(this.pkColumns)).append(")");
        } else if (this.ukColumns != null) {
            b.append("UNIQUE KEY ").append(this.ukName).append(" (").append(PlainSelect.getStringList(this.ukColumns)).append(")");
        }
        return b.toString();
    }
}

