/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.update;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;

public class Update
implements Statement {
    private List<Table> tables;
    private Expression where;
    private List<Column> columns;
    private List<Expression> expressions;
    private FromItem fromItem;
    private List<Join> joins;
    private Select select;
    private boolean useColumnsBrackets = true;
    private boolean useSelect = false;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setTables(List<Table> list) {
        this.tables = list;
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public void setColumns(List<Column> list) {
        this.columns = list;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public boolean isUseColumnsBrackets() {
        return this.useColumnsBrackets;
    }

    public void setUseColumnsBrackets(boolean useColumnsBrackets) {
        this.useColumnsBrackets = useColumnsBrackets;
    }

    public boolean isUseSelect() {
        return this.useSelect;
    }

    public void setUseSelect(boolean useSelect) {
        this.useSelect = useSelect;
    }

    public String toString() {
        int i;
        StringBuilder b = new StringBuilder("UPDATE ");
        b.append(PlainSelect.getStringList(this.getTables(), true, false)).append(" SET ");
        if (!this.useSelect) {
            for (i = 0; i < this.getColumns().size(); ++i) {
                if (i != 0) {
                    b.append(", ");
                }
                b.append(this.columns.get(i)).append(" = ");
                b.append(this.expressions.get(i));
            }
        } else {
            if (this.useColumnsBrackets) {
                b.append("(");
            }
            for (i = 0; i < this.getColumns().size(); ++i) {
                if (i != 0) {
                    b.append(", ");
                }
                b.append(this.columns.get(i));
            }
            if (this.useColumnsBrackets) {
                b.append(")");
            }
            b.append(" = ");
            b.append("(").append(this.select).append(")");
        }
        if (this.fromItem != null) {
            b.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        b.append(", ").append(join);
                        continue;
                    }
                    b.append(" ").append(join);
                }
            }
        }
        if (this.where != null) {
            b.append(" WHERE ");
            b.append(this.where);
        }
        return b.toString();
    }
}

