/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm.test;

import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class MongoModifyASM
implements IASM,
Opcodes {
    private Configure conf = Configure.getInstance();

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!this.conf.hook_mongodb_enabled) {
            return cv;
        }
        if ("com/mongodb/connection/InternalConnection".equals(className)) {
            return new InternalConnectionCV(cv, className);
        }
        return cv;
    }

    static class InternalConnectionCV
    extends ClassVisitor
    implements Opcodes {
        public String className;

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            int newAccess = access;
            if ((access & 1) == 0) {
                newAccess = access | 1;
            }
            super.visit(version, newAccess, name, signature, superName, interfaces);
        }

        @Override
        public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, methodName, desc, signature, exceptions);
            int newAccess = access;
            if ((access & 1) == 0) {
                newAccess = access | 1;
            }
            return super.visitMethod(newAccess, methodName, desc, signature, exceptions);
        }

        public InternalConnectionCV(ClassVisitor cv, String className) {
            super(589824, cv);
            this.className = className;
        }
    }
}

