/*
 * Decompiled with CFR 0.152.
 */
package scouter.test;

import java.util.ArrayList;
import scouter.agent.AgentBoot;
import scouter.agent.counter.CounterBasket;
import scouter.agent.counter.task.AgentHeartBeat;
import scouter.agent.netio.data.DataProxy;
import scouter.lang.pack.PerfCounterPack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.util.HashUtil;
import scouter.util.ShellArg;
import scouter.util.SysJMX;
import scouter.util.ThreadUtil;

public class ObjectRush {
    public static void main(String[] args) {
        ShellArg sh = new ShellArg(args);
        String server = sh.get("-h", "127.0.0.1");
        String port = sh.get("-p", "6100");
        int objNum = Integer.valueOf(sh.get("-n", "20"));
        System.setProperty("server.addr", server);
        System.setProperty("server.port", port);
        AgentBoot.boot();
        ArrayList<String> objNames = new ArrayList<String>();
        for (int i = 0; i < objNum; ++i) {
            String objName = "/" + SysJMX.getHostName() + "/dummy_java_instance_" + (i + 1);
            objNames.add(objName);
            int objHash = HashUtil.hash(objName);
            AgentHeartBeat.addObject("java", objHash, objName);
        }
        CounterBasket basket = new CounterBasket();
        boolean count = false;
        while (true) {
            for (String objName : objNames) {
                PerfCounterPack pcp = basket.getPack(objName, (byte)1);
                pcp.put("TPS", new DecimalValue(5L));
                pcp.put("ActiveSpeed", new DecimalValue(5L));
                pcp.put("ElapsedTime", new DecimalValue(5L));
                pcp.put("Elapsed90%", new DecimalValue(5L));
                pcp.put("ServiceCount", new DecimalValue(5L));
                pcp.put("ErrorRate", new DecimalValue(5L));
                pcp.put("RecentUser", new DecimalValue(5L));
                pcp.put("ActiveService", new DecimalValue(5L));
                pcp.put("GcCount", new DecimalValue(5L));
                pcp.put("GcTime", new DecimalValue(5L));
                pcp.put("HeapUsed", new DecimalValue(5L));
                pcp.put("PermUsed", new DecimalValue(5L));
                pcp.put("ProcCpu", new DecimalValue(5L));
                int act1 = (int)(Math.random() * 10.0);
                int act2 = (int)(Math.random() * 10.0);
                int act3 = (int)(Math.random() * 10.0);
                int active = act1 + act2 + act3;
                ListValue activeSpeed = new ListValue();
                activeSpeed.add(act1);
                activeSpeed.add(act2);
                activeSpeed.add(act3);
                pcp.put("ActiveSpeed", activeSpeed);
                pcp.put("ActiveService", new DecimalValue(active));
                PerfCounterPack fiveminPcp = basket.getPack(objName, (byte)3);
                fiveminPcp.put("TPS", new DecimalValue(5L));
                fiveminPcp.put("ActiveSpeed", new DecimalValue(5L));
                fiveminPcp.put("ElapsedTime", new DecimalValue(5L));
                fiveminPcp.put("Elapsed90%", new DecimalValue(5L));
                fiveminPcp.put("ServiceCount", new DecimalValue(5L));
                fiveminPcp.put("ErrorRate", new DecimalValue(5L));
                fiveminPcp.put("RecentUser", new DecimalValue(5L));
                fiveminPcp.put("ActiveService", new DecimalValue(5L));
                fiveminPcp.put("GcCount", new DecimalValue(5L));
                fiveminPcp.put("GcTime", new DecimalValue(5L));
                fiveminPcp.put("HeapUsed", new DecimalValue(5L));
                fiveminPcp.put("PermUsed", new DecimalValue(5L));
                fiveminPcp.put("ProcCpu", new DecimalValue(5L));
                DataProxy.sendCounter(new PerfCounterPack[]{pcp, fiveminPcp});
            }
            ThreadUtil.sleep(2000L);
        }
    }
}

