/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

class StackUtil {
    private MBeanServerConnection server;
    private ThreadMXBean mXBean;
    private ObjectName objName;
    private String headerString;
    private boolean hasDumpAllThreads;

    public StackUtil(MBeanServerConnection server) throws IOException {
        this.server = server;
        this.mXBean = ManagementFactory.newPlatformMXBeanProxy(server, "java.lang:type=Threading", ThreadMXBean.class);
        try {
            this.objName = new ObjectName("java.lang:type=Threading");
            this.checkDumpAllThreads();
            this.headerString = this.getHeaderString();
        }
        catch (Exception e) {
            InternalError ie = new InternalError(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public StackUtil() {
        this.mXBean = ManagementFactory.getThreadMXBean();
        this.checkDumpAllThreads();
        this.headerString = this.getHeaderString();
    }

    private Properties getSystemProperties() {
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            if (runtime != null) {
                Properties prop = new Properties();
                prop.putAll(runtime.getSystemProperties());
                return prop;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getHeaderString() {
        Properties prop = this.getSystemProperties();
        StringBuilder sb = new StringBuilder(100);
        sb.append("Full thread dump ").append(prop.getProperty("java.vm.name")).append(" (").append(prop.getProperty("java.vm.version")).append(' ').append(prop.getProperty("java.vm.info"));
        return sb.toString();
    }

    public List<String> takeThreadDump() throws Exception {
        ThreadInfo[] threads;
        ThreadMXBean threadMXBean = this.mXBean;
        if (threadMXBean == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(100);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        list.add(df.format(new Date()));
        list.add(this.headerString);
        if (this.hasDumpAllThreads) {
            threads = threadMXBean.dumpAllThreads(true, true);
        } else {
            long[] threadIds = threadMXBean.getAllThreadIds();
            threads = threadMXBean.getThreadInfo(threadIds, Integer.MAX_VALUE);
        }
        this.printThreads(list, threadMXBean, threads);
        return list;
    }

    private void printThreads(List<String> list, ThreadMXBean threadMXBean, ThreadInfo[] threads) {
        boolean jdk16 = this.hasDumpAllThreads;
        for (ThreadInfo thread : threads) {
            if (thread == null) continue;
            if (jdk16) {
                this.print16Thread(list, threadMXBean, thread);
                continue;
            }
            this.print15Thread(list, thread);
        }
    }

    private void print16Thread(List<String> list, ThreadMXBean threadMXBean, ThreadInfo thread) {
        MonitorInfo[] monitors = null;
        if (threadMXBean.isObjectMonitorUsageSupported()) {
            monitors = thread.getLockedMonitors();
        }
        list.add("");
        list.add(new StringBuilder(100).append('\"').append(thread.getThreadName()).append("\" - Thread t@").append(thread.getThreadId()).toString());
        list.add("   java.lang.Thread.State: " + (Object)((Object)thread.getThreadState()));
        int index = 0;
        LockInfo lock = thread.getLockInfo();
        String lockOwner = thread.getLockOwnerName();
        for (StackTraceElement st : thread.getStackTrace()) {
            list.add("\tat " + st.toString());
            if (index == 0) {
                StringBuilder sb;
                if ("java.lang.Object".equals(st.getClassName()) && "wait".equals(st.getMethodName())) {
                    if (lock != null) {
                        sb = new StringBuilder(100);
                        sb.append("\t- waiting on ");
                        this.printLock(sb, lock);
                        list.add(sb.toString());
                    }
                } else if (lock != null) {
                    if (lockOwner == null) {
                        sb = new StringBuilder(100);
                        sb.append("\t- parking to wait for ");
                        this.printLock(sb, lock);
                    } else {
                        sb = new StringBuilder(100);
                        sb.append("\t- waiting to lock ");
                        this.printLock(sb, lock);
                        sb.append(" owned by \"").append(lockOwner).append("\" t@").append(thread.getLockOwnerId());
                        this.printLock(sb, lock);
                    }
                }
            }
            this.printMonitors(list, monitors, index);
            ++index;
        }
    }

    private void printMonitors(List<String> list, MonitorInfo[] monitors, int index) {
        if (monitors != null) {
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != index) continue;
                StringBuilder sb = new StringBuilder(100);
                sb.append("\t- locked ");
                this.printLock(sb, mi);
                list.add(sb.toString());
            }
        }
    }

    private void print15Thread(List<String> list, ThreadInfo thread) {
        list.add("");
        list.add(new StringBuilder(100).append('\"').append(thread.getThreadName()).append("\" - Thread t@").append(thread.getThreadId()).toString());
        StringBuilder sb = new StringBuilder(100);
        sb.append("   java.lang.Thread.State: ").append((Object)thread.getThreadState());
        if (thread.getLockName() != null) {
            sb.append(" on ").append(thread.getLockName());
            if (thread.getLockOwnerName() != null) {
                sb.append(" owned by: ").append(thread.getLockOwnerName());
            }
        }
        list.add(sb.toString());
        for (StackTraceElement st : thread.getStackTrace()) {
            list.add("\tat " + st.toString());
        }
    }

    private void printLock(StringBuilder sb, LockInfo lock) {
        sb.append('<').append(Integer.toHexString(lock.getIdentityHashCode())).append("> (a ").append(lock.getClassName()).append(')');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDumpAllThreads() {
        StackUtil stackUtil = this;
        synchronized (stackUtil) {
            block9: {
                this.hasDumpAllThreads = false;
                if (this.server == null) {
                    if (System.getProperty("java.version").compareTo("1.5") >= 0) {
                        this.hasDumpAllThreads = true;
                    }
                } else {
                    try {
                        MBeanOperationInfo[] mopis = this.server.getMBeanInfo(this.objName).getOperations();
                        if (mopis == null) break block9;
                        for (MBeanOperationInfo op : mopis) {
                            if (!"dumpAllThreads".equals(op.getName())) continue;
                            this.hasDumpAllThreads = true;
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }
}

