/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.filter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.util.StringUtil;
import scouterx.webapp.framework.configure.ConfigureAdaptor;
import scouterx.webapp.framework.configure.ConfigureManager;
import scouterx.webapp.framework.exception.ErrorState;
import scouterx.webapp.framework.session.UserToken;
import scouterx.webapp.framework.session.WebRequestContext;
import scouterx.webapp.framework.util.ZZ;
import scouterx.webapp.layer.service.UserTokenService;

public class AuthFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthFilter.class);
    private static final String BEARER_PREFIX = "bearer ";
    @Context
    private HttpServletRequest servletRequest;
    UserTokenService userTokenService = new UserTokenService();

    public void filter(ContainerRequestContext requestContext) {
        WebRequestContext.clearUserToken();
        ConfigureAdaptor conf = ConfigureManager.getConfigure();
        boolean violation = false;
        if (conf.isNetHttpApiAuthIpEnabled()) {
            String ip = ZZ.getRequestIp(this.servletRequest);
            if (conf.getNetHttpApiAllowIpExact().contains(ip)) {
                return;
            }
            if (conf.getNetHttpApiAllowIpMatch().stream().anyMatch(match -> match.include(ip))) {
                return;
            }
            violation = true;
        }
        if (conf.isNetHttpApiAuthBearerTokenEnabled()) {
            String authHeader = this.servletRequest.getHeader("Authorization");
            if (StringUtil.isNotEmpty((String)authHeader)) {
                UserToken token = UserToken.fromBearerToken(this.trimToken(authHeader));
                this.userTokenService.validateToken(token);
                WebRequestContext.setUserToken(token);
                return;
            }
            if (!conf.isNetHttpApiAuthSessionEnabled()) {
                throw ErrorState.SESSION_EXPIRED.newBizException();
            }
        }
        if (conf.isNetHttpApiAuthSessionEnabled()) {
            HttpSession session = this.servletRequest.getSession();
            if (session == null || session.getAttribute("userId") == null) {
                throw ErrorState.LOGIN_REQUIRED.newBizException();
            }
            UserToken userToken = UserToken.fromSessionId((String)session.getAttribute("userId"));
            WebRequestContext.setUserToken(userToken);
        }
        if (violation) {
            throw ErrorState.SESSION_EXPIRED.newBizException();
        }
    }

    private String trimToken(String authHeader) {
        return StringUtil.limiting((String)authHeader, (int)BEARER_PREFIX.length()).toLowerCase().equals(BEARER_PREFIX) ? authHeader.substring(7) : authHeader;
    }
}

