/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.filter;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.MDC;

public class LoggingInitServletFilter
implements Filter {
    private static final String RID = Integer.toString(new Random(System.currentTimeMillis()).nextInt(30000) + 2000, 32);
    private static final String INSTANCE_ID_KEY = "scouter.instanceId";
    private static final String INSTANCE_ID = System.getProperty("scouter.instanceId", "#");
    private static final String LOG_TRACE_HEADER = INSTANCE_ID + RID;
    public static final String requestId = "requestId";
    private static AtomicInteger counter = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.initLogging(request);
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.clear();
        }
    }

    void initLogging(ServletRequest request) {
        int requestId = counter.getAndIncrement();
        String logTraceId = LOG_TRACE_HEADER + requestId;
        MDC.put((String)requestId, (String)logTraceId);
    }

    void clear() {
        MDC.remove((String)requestId);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

