/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.util;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import scouter.util.StringUtil;
import scouterx.webapp.framework.configure.ConfigureAdaptor;
import scouterx.webapp.framework.configure.ConfigureManager;

public class ZZ {
    private static final ConfigureAdaptor conf = ConfigureManager.getConfigure();
    private static final char BRACKET = '[';
    private static final char COMMA = ',';

    public static String getRequestIp(HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)conf.getNetHttpApiAuthIpHeaderKey())) {
            String ipString = request.getHeader(conf.getNetHttpApiAuthIpHeaderKey());
            if (StringUtil.isEmpty((String)ipString)) {
                return request.getRemoteAddr();
            }
            if (ipString.contains(",")) {
                return StringUtil.split((String)ipString, (char)',')[0].trim();
            }
            StringUtil.split((String)ipString, (char)',');
            return ipString;
        }
        return request.getRemoteAddr();
    }

    public static String ipByteToString(byte[] ip) {
        if (ip == null) {
            return "0.0.0.0";
        }
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(ip[0] & 0xFF);
            sb.append(".");
            sb.append(ip[1] & 0xFF);
            sb.append(".");
            sb.append(ip[2] & 0xFF);
            sb.append(".");
            sb.append(ip[3] & 0xFF);
            return sb.toString();
        }
        catch (Throwable e) {
            return "0.0.0.0";
        }
    }

    public static String stripFirstLastBracket(String org) {
        if (org.charAt(0) == '[') {
            return org.substring(1, org.length() - 1);
        }
        return org;
    }

    public static List<String> splitParam(String org) {
        org = ZZ.stripFirstLastBracket(org);
        return Arrays.asList(StringUtils.split((String)org, (char)','));
    }

    public static Set<String> splitParamStringSet(String org) {
        org = ZZ.stripFirstLastBracket(org);
        String[] items = StringUtils.split((String)org, (char)',');
        return Arrays.stream(items).collect(Collectors.toSet());
    }

    public static List<Integer> splitParamAsInteger(String org) {
        org = ZZ.stripFirstLastBracket(org);
        String[] items = StringUtils.split((String)org, (char)',');
        return Arrays.stream(items).map(Integer::parseInt).collect(Collectors.toList());
    }

    public static List<Long> splitParamAsLong(String org) {
        org = ZZ.stripFirstLastBracket(org);
        String[] items = StringUtils.split((String)org, (char)',');
        return Arrays.stream(items).map(Long::parseLong).collect(Collectors.toList());
    }

    public static Set<Integer> splitParamAsIntegerSet(String org) {
        org = ZZ.stripFirstLastBracket(org);
        String[] items = StringUtils.split((String)org, (char)',');
        return Arrays.stream(items).map(Integer::parseInt).collect(Collectors.toSet());
    }
}

