/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.consumer;

import java.util.List;
import java.util.stream.Collectors;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.model.ActiveThread;
import scouterx.webapp.model.scouter.SActiveService;
import scouterx.webapp.model.scouter.SActiveServiceStepCount;

public class ActiveServiceConsumer {
    public List<SActiveServiceStepCount> retrieveRealTimeActiveServiceByObjType(String objType, Server server) {
        List<Pack> results;
        MapPack paramPack = new MapPack();
        paramPack.put("objType", objType);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            results = tcpProxy.process("ACTIVESPEED_REAL_TIME", (Pack)paramPack);
        }
        return results.stream().map(pack -> (MapPack)pack).map(SActiveServiceStepCount::of).collect(Collectors.toList());
    }

    public List<SActiveService> retrieveActiveServiceListByType(String objType, Server server) {
        MapPack paramPack = new MapPack();
        paramPack.put("objType", objType);
        List<Pack> packList = this.retrieveActiveService(paramPack, server);
        return SActiveService.ofPackList(packList);
    }

    public List<SActiveService> retrieveActiveServiceListByObjHash(int objHash, Server server) {
        MapPack paramPack = new MapPack();
        paramPack.put("objHash", (long)objHash);
        List<Pack> packList = this.retrieveActiveService(paramPack, server);
        return SActiveService.ofPackList(packList);
    }

    public List<Pack> retrieveActiveService(MapPack paramPack, Server server) {
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            List<Pack> list = tcpProxy.process("OBJECT_ACTIVE_SERVICE_LIST", (Pack)paramPack);
            return list;
        }
    }

    public ActiveThread retrieveActiveThread(int objHash, long threadId, long txid, Server server) {
        MapPack paramPack = new MapPack();
        paramPack.put("objHash", (long)objHash);
        paramPack.put("id", threadId);
        paramPack.put("txid", txid);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            MapPack resultPack = (MapPack)tcpProxy.getSingle("OBJECT_THREAD_DETAIL", (Pack)paramPack);
            ActiveThread activeThread = ActiveThread.of(resultPack);
            return activeThread;
        }
    }
}

