/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouterx.webapp.framework.client.model.AgentModelThread;
import scouterx.webapp.framework.client.model.AgentObject;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.model.scouter.SCounter;
import scouterx.webapp.request.CounterAvgRequest;
import scouterx.webapp.request.CounterAvgRequestByObjHashes;
import scouterx.webapp.request.CounterAvgRequestByType;
import scouterx.webapp.request.CounterRequest;
import scouterx.webapp.request.CounterRequestByObjHashes;
import scouterx.webapp.request.CounterRequestByType;
import scouterx.webapp.view.AvgCounterView;
import scouterx.webapp.view.CounterView;

public class CounterConsumer {
    public List<SCounter> retrieveRealTimeCountersByObjType(String objType, Set<String> counterNames, Server server) {
        return this.retrieveRealTimeCountersByObjTypeOrObjHashes(objType, null, counterNames, server);
    }

    public List<SCounter> retrieveRealTimeCountersByObjHashes(Set<Integer> objHashSet, Set<String> counterNames, Server server) {
        return this.retrieveRealTimeCountersByObjTypeOrObjHashes(null, objHashSet, counterNames, server);
    }

    public List<CounterView> retrieveCounterByObjType(CounterRequestByType request) {
        return this.retrieveCounterByObjTypeOrObjHashes(request);
    }

    public List<CounterView> retrieveCounterByObjHashes(CounterRequestByObjHashes request) {
        return this.retrieveCounterByObjTypeOrObjHashes(request);
    }

    private List<CounterView> retrieveCounterByObjTypeOrObjHashes(CounterRequest request) {
        long startDateUnit;
        Server server = ServerManager.getInstance().getServerIfNullDefault(request.getServerId());
        MapPack paramPack = new MapPack();
        if (request instanceof CounterRequestByType) {
            paramPack.put("objType", ((CounterRequestByType)request).getObjType());
        } else if (request instanceof CounterRequestByObjHashes) {
            ListValue objHashLv = paramPack.newList("objHash");
            for (Integer objHash : ((CounterRequestByObjHashes)request).getObjHashes()) {
                objHashLv.add((long)objHash.intValue());
            }
        }
        paramPack.put("counter", request.getCounter());
        HashMap<Integer, CounterView> counterViewMap = new HashMap<Integer, CounterView>();
        long dateUnit = startDateUnit = DateUtil.getDateUnit((long)request.getStartTimeMillis());
        while (DateUtil.dateUnitToTimeMillis((long)dateUnit) < request.getEndTimeMillis()) {
            paramPack.put("stime", Math.max(DateUtil.dateUnitToTimeMillis((long)dateUnit) + 1000L, request.getStartTimeMillis()));
            paramPack.put("etime", Math.min(DateUtil.dateUnitToTimeMillis((long)dateUnit) + 86400000L - 1000L, request.getEndTimeMillis()));
            List<CounterView> counterViews = this.retrieveCounterInDay(request, server, paramPack);
            for (CounterView counterView : counterViews) {
                CounterView counterViewInMap = (CounterView)counterViewMap.get(counterView.getObjHash());
                if (counterViewInMap == null) {
                    counterViewMap.put(counterView.getObjHash(), counterView);
                    continue;
                }
                counterViewInMap.getTimeList().addAll(counterView.getTimeList());
                counterViewInMap.getValueList().addAll(counterView.getValueList());
                counterViewInMap.setEndTimeMillis(counterView.getEndTimeMillis());
            }
            ++dateUnit;
        }
        return new ArrayList<CounterView>(counterViewMap.values());
    }

    private List<CounterView> retrieveCounterInDay(CounterRequest request, Server server, MapPack paramPack) {
        ArrayList<CounterView> counterViewList = new ArrayList<CounterView>();
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            tcpProxy.process("COUNTER_PAST_TIME_ALL", paramPack, in -> {
                MapPack mapPack = (MapPack)in.readPack();
                if (mapPack != null) {
                    int objHash = mapPack.getInt("objHash");
                    ListValue timeList = mapPack.getList("time");
                    ListValue valueList = mapPack.getList("value");
                    ArrayList<Double> valueToDoubleList = new ArrayList<Double>();
                    for (int i = 0; i < timeList.size(); ++i) {
                        valueToDoubleList.add(valueList.getDouble(i));
                    }
                    AgentObject agentObject = AgentModelThread.getInstance().getAgentObject(objHash);
                    String objType = agentObject.getObjType();
                    CounterView counterView = CounterView.builder().objHash(objHash).objName(agentObject.getObjName()).name(request.getCounter()).displayName(server.getCounterEngine().getCounterDisplayName(objType, request.getCounter())).unit(server.getCounterEngine().getCounterUnit(objType, request.getCounter())).startTimeMillis(request.getStartTimeMillis()).endTimeMillis(request.getEndTimeMillis()).timeList(Arrays.stream(timeList.toObjectArray()).map(Long.class::cast).collect(Collectors.toList())).valueList(valueToDoubleList).build();
                    counterViewList.add(counterView);
                }
            });
        }
        return counterViewList;
    }

    public List<AvgCounterView> retrieveAvgCounterByObjType(CounterAvgRequestByType request) {
        return this.retrieveAvgCounterByObjTypeOrHashes(request);
    }

    public List<AvgCounterView> retrieveAvgCounterByObjHashes(CounterAvgRequestByObjHashes request) {
        return this.retrieveAvgCounterByObjTypeOrHashes(request);
    }

    public List<AvgCounterView> retrieveAvgCounterByObjTypeOrHashes(CounterAvgRequest request) {
        MapPack paramPack = new MapPack();
        if (request instanceof CounterAvgRequestByType) {
            paramPack.put("objType", ((CounterAvgRequestByType)request).getObjType());
        } else if (request instanceof CounterAvgRequestByObjHashes) {
            ListValue objHashLv = paramPack.newList("objHash");
            for (Integer objHash : ((CounterAvgRequestByObjHashes)request).getObjHashes()) {
                objHashLv.add((long)objHash.intValue());
            }
        }
        paramPack.put("sDate", request.getStartYmd());
        paramPack.put("eDate", request.getEndYmd());
        paramPack.put("counter", request.getCounter());
        HashMap counterViewMap = new HashMap();
        Server server = ServerManager.getInstance().getServerIfNullDefault(request.getServerId());
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            tcpProxy.process("COUNTER_PAST_LONGDATE_ALL", paramPack, in -> {
                MapPack mapPack = (MapPack)in.readPack();
                if (mapPack != null) {
                    int objHash = mapPack.getInt("objHash");
                    ListValue timeList = mapPack.getList("time");
                    ListValue valueList = mapPack.getList("value");
                    ArrayList<Double> valueToDoubleList = new ArrayList<Double>();
                    for (int i = 0; i < timeList.size(); ++i) {
                        valueToDoubleList.add(valueList.getDouble(i));
                    }
                    AgentObject agentObject = AgentModelThread.getInstance().getAgentObject(objHash);
                    String objType = agentObject.getObjType();
                    AvgCounterView counterView = AvgCounterView.builder().objHash(objHash).objName(agentObject.getObjName()).name(request.getCounter()).displayName(server.getCounterEngine().getCounterDisplayName(objType, request.getCounter())).unit(server.getCounterEngine().getCounterUnit(objType, request.getCounter())).fromYmd(request.getStartYmd()).toYmd(request.getEndYmd()).timeList(Arrays.stream(timeList.toObjectArray()).map(Long.class::cast).collect(Collectors.toList())).valueList(valueToDoubleList).build();
                    AvgCounterView counterViewInMap = (AvgCounterView)counterViewMap.get(counterView.getObjHash());
                    if (counterViewInMap == null) {
                        counterViewMap.put(counterView.getObjHash(), counterView);
                    } else {
                        counterViewInMap.getTimeList().addAll(counterView.getTimeList());
                        counterViewInMap.getValueList().addAll(counterView.getValueList());
                    }
                }
            });
        }
        return new ArrayList<AvgCounterView>(counterViewMap.values());
    }

    private List<SCounter> retrieveRealTimeCountersByObjTypeOrObjHashes(String objType, Set<Integer> objHashSet, Set<String> counterNames, Server server) {
        MapPack mapPack;
        MapPack paramPack = new MapPack();
        paramPack.put("objType", objType);
        ListValue counterNameLv = paramPack.newList("counter");
        for (String string : counterNames) {
            counterNameLv.add(string);
        }
        ListValue objHashLv = paramPack.newList("objHash");
        if (objHashSet != null) {
            for (Integer objHash : objHashSet) {
                objHashLv.add((long)objHash.intValue());
            }
        }
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            mapPack = (MapPack)tcpProxy.getSingle("COUNTER_REAL_TIME_ALL_MULTI", (Pack)paramPack);
        }
        if (mapPack == null) {
            return Collections.emptyList();
        }
        ListValue rObjHashLv = (ListValue)mapPack.get("objHash");
        ListValue rCounterNameLv = (ListValue)mapPack.get("counter");
        ListValue rCounterValueLv = (ListValue)mapPack.get("value");
        ArrayList<SCounter> resultList = new ArrayList<SCounter>();
        for (int i = 0; i < rObjHashLv.size(); ++i) {
            int objHash = CastUtil.cint((Object)rObjHashLv.get(i));
            String counterName = rCounterNameLv.getString(i);
            Object counterValue = rCounterValueLv.get(i).toJavaObject();
            resultList.add(new SCounter(objHash, counterName, counterValue));
        }
        return resultList;
    }
}

