/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import scouter.lang.constants.ParamConstant;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.TextValue;
import scouter.lang.value.Value;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.model.KeyValueData;

public class GlobalKvStoreConsumer {
    public boolean set(String key, String value, Server server) {
        return this.set(key, value, ParamConstant.TTL_PERMANENT, server);
    }

    public boolean set(String key, String value, long ttl, Server server) {
        Value returnValue = null;
        MapPack mapPack = new MapPack();
        mapPack.put("key", key);
        mapPack.put("value", value);
        mapPack.put("ttl", ttl);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            returnValue = tcpProxy.getSingleValue("SET_GLOBAL_KV", (Pack)mapPack);
        }
        return returnValue != null ? (Boolean)returnValue.toJavaObject() : false;
    }

    public boolean setTTL(String key, long ttl, Server server) {
        Value returnValue = null;
        MapPack mapPack = new MapPack();
        mapPack.put("key", key);
        mapPack.put("ttl", ttl);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            returnValue = tcpProxy.getSingleValue("SET_GLOBAL_TTL", (Pack)mapPack);
        }
        return returnValue != null ? (Boolean)returnValue.toJavaObject() : false;
    }

    public String get(String key, Server server) {
        Value value = null;
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            value = tcpProxy.getSingleValue("GET_GLOBAL_KV", (Value)new TextValue(key));
        }
        return value != null ? value.toString() : null;
    }

    public List<KeyValueData> setBulk(Map<String, String> paramMap, Server server) {
        return this.setBulk(paramMap, ParamConstant.TTL_PERMANENT, server);
    }

    public List<KeyValueData> setBulk(Map<String, String> paramMap, Long ttl, Server server) {
        MapPack resultPack;
        MapPack input = new MapPack();
        input.put("kv", (Value)MapValue.ofStringValueMap(paramMap));
        input.put("ttl", ttl.longValue());
        TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);
        Object object = null;
        try {
            resultPack = (MapPack)tcpProxy.getSingle("SET_GLOBAL_KV_BULK", (Pack)input);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tcpProxy != null) {
                if (object != null) {
                    try {
                        tcpProxy.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tcpProxy.close();
                }
            }
        }
        ArrayList<KeyValueData> resultList = new ArrayList<KeyValueData>();
        for (String key : resultPack.keySet()) {
            resultList.add(new KeyValueData(key, resultPack.getBoolean(key)));
        }
        return resultList;
    }

    public List<KeyValueData> getBulk(List<String> paramList, Server server) {
        MapPack resultPack;
        MapPack paramPack = new MapPack();
        paramPack.put("key", (Value)ListValue.ofStringValueList(paramList));
        TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);
        Object object = null;
        try {
            resultPack = (MapPack)tcpProxy.getSingle("GET_GLOBAL_KV_BULK", (Pack)paramPack);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tcpProxy != null) {
                if (object != null) {
                    try {
                        tcpProxy.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tcpProxy.close();
                }
            }
        }
        ArrayList<KeyValueData> resultList = new ArrayList<KeyValueData>();
        for (String key : resultPack.keySet()) {
            resultList.add(new KeyValueData(key, resultPack.getText(key)));
        }
        return resultList;
    }
}

