/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.consumer;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.lang.value.ListValue;
import scouterx.webapp.framework.client.net.INetReader;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.model.XLogData;
import scouterx.webapp.model.scouter.SXLog;
import scouterx.webapp.request.GxidXLogRequest;
import scouterx.webapp.request.MultiXLogRequest;
import scouterx.webapp.request.PageableXLogRequest;
import scouterx.webapp.request.RealTimeXLogRequest;
import scouterx.webapp.request.SearchXLogRequest;
import scouterx.webapp.request.SingleXLogRequest;
import scouterx.webapp.view.PageableXLogView;
import scouterx.webapp.view.RealTimeXLogView;

public class XLogConsumer {
    private static final Logger log = LoggerFactory.getLogger(XLogConsumer.class);

    public void handleRealTimeXLog(RealTimeXLogRequest xLogRequest, INetReader reader) {
        boolean isFirst = false;
        int firstRetrieveLimit = 10000;
        if (xLogRequest.getXLogLoop() == 0L && xLogRequest.getXLogIndex() == 0) {
            isFirst = true;
        }
        String cmd = isFirst ? "TRANX_REAL_TIME_GROUP_LATEST" : "TRANX_REAL_TIME_GROUP";
        MapPack paramPack = new MapPack();
        paramPack.put("index", (long)xLogRequest.getXLogIndex());
        paramPack.put("loop", xLogRequest.getXLogLoop());
        paramPack.put("count", (long)firstRetrieveLimit);
        ListValue objHashLv = paramPack.newList("objHash");
        for (Integer hash : xLogRequest.getObjHashes()) {
            objHashLv.add((long)hash.intValue());
        }
        RealTimeXLogView xLogView = new RealTimeXLogView();
        ArrayList<SXLog> xLogList = new ArrayList<SXLog>();
        xLogView.setXLogs(xLogList);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(xLogRequest.getServerId());){
            tcpProxy.process(cmd, paramPack, reader);
        }
    }

    public void handlePageableXLog(PageableXLogRequest pageableXLogRequest, INetReader reader) {
        MapPack paramPack = new MapPack();
        paramPack.put("date", pageableXLogRequest.getYyyymmdd());
        paramPack.put("stime", pageableXLogRequest.getStartTimeMillis());
        paramPack.put("txid", pageableXLogRequest.getLastTxid());
        paramPack.put("etime", pageableXLogRequest.getEndTimeMillis());
        paramPack.put("lastBucketTime", pageableXLogRequest.getLastXLogTime());
        paramPack.put("pageCount", (long)pageableXLogRequest.getPageCount());
        ListValue objHashLv = paramPack.newList("objHash");
        for (Integer hash : pageableXLogRequest.getObjHashes()) {
            objHashLv.add((long)hash.intValue());
        }
        PageableXLogView view = new PageableXLogView();
        ArrayList<SXLog> xLogList = new ArrayList<SXLog>();
        view.setXLogs(xLogList);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(pageableXLogRequest.getServerId());){
            tcpProxy.process("TRANX_LOAD_TIME_GROUP_V2", paramPack, reader);
        }
    }

    public List<SXLog> searchXLogList(SearchXLogRequest searchXLogRequest) {
        List<Pack> searchXLogPackList = this.searchXLogPackList(searchXLogRequest);
        ArrayList<SXLog> result = new ArrayList<SXLog>();
        for (Pack pack : searchXLogPackList) {
            result.add(SXLog.of((XLogPack)pack));
        }
        return result;
    }

    public List<XLogData> searchXLogDataList(SearchXLogRequest searchXLogRequest) {
        List<Pack> searchXLogPackList = this.searchXLogPackList(searchXLogRequest);
        ArrayList<XLogData> result = new ArrayList<XLogData>();
        for (Pack pack : searchXLogPackList) {
            result.add(XLogData.of((XLogPack)pack, searchXLogRequest.getServerId()));
        }
        return result;
    }

    public XLogData retrieveByTxidAsXLogData(SingleXLogRequest singleXLogRequest) {
        XLogPack pack = this.retrieveByTxid(singleXLogRequest);
        return pack == null ? null : XLogData.of(pack, singleXLogRequest.getServerId());
    }

    public SXLog retrieveByTxidAsXLog(SingleXLogRequest singleXLogRequest) {
        XLogPack pack = this.retrieveByTxid(singleXLogRequest);
        return pack == null ? null : SXLog.of(pack);
    }

    public List<SXLog> retrieveXLogListByGxid(GxidXLogRequest xlogRequest) {
        return this.retrieveXLogPacksByGxid(xlogRequest).stream().map(pack -> (XLogPack)pack).map(SXLog::of).collect(Collectors.toList());
    }

    public List<XLogData> retrieveXLogDataListByGxid(GxidXLogRequest xLogRequest) {
        return this.retrieveXLogPacksByGxid(xLogRequest).stream().map(pack -> (XLogPack)pack).map(pack -> XLogData.of(pack, xLogRequest.getServerId())).collect(Collectors.toList());
    }

    public List<XLogData> retrieveXLogDataListByTxids(MultiXLogRequest multiXLogRequest) {
        return this.retrieveXLogPacksByTxids(multiXLogRequest).stream().map(pack -> (XLogPack)pack).map(pack -> XLogData.of(pack, multiXLogRequest.getServerId())).collect(Collectors.toList());
    }

    private XLogPack retrieveByTxid(SingleXLogRequest singleXLogRequest) {
        XLogPack pack;
        MapPack param = new MapPack();
        param.put("date", singleXLogRequest.getYyyymmdd());
        param.put("txid", singleXLogRequest.getTxid());
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(singleXLogRequest.getServerId());){
            pack = (XLogPack)tcpProxy.getSingle("XLOG_READ_BY_TXID", (Pack)param);
        }
        return pack;
    }

    private List<Pack> retrieveXLogPacksByGxid(GxidXLogRequest xlogRequest) {
        List<Pack> results;
        MapPack param = new MapPack();
        param.put("date", xlogRequest.getYyyymmdd());
        param.put("gxid", xlogRequest.getGxid());
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(xlogRequest.getServerId());){
            results = tcpProxy.process("XLOG_READ_BY_GXID", (Pack)param);
        }
        return results;
    }

    private List<Pack> retrieveXLogPacksByTxids(MultiXLogRequest xlogRequest) {
        List<Pack> results;
        MapPack param = new MapPack();
        param.put("date", xlogRequest.getYyyymmdd());
        ListValue xlogLv = param.newList("txid");
        xlogRequest.getTxidList().forEach(arg_0 -> ((ListValue)xlogLv).add(arg_0));
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(xlogRequest.getServerId());){
            results = tcpProxy.process("XLOG_LOAD_BY_TXIDS", (Pack)param);
        }
        return results;
    }

    private List<Pack> searchXLogPackList(SearchXLogRequest searchXLogRequest) {
        String textTemp;
        String desc;
        String login;
        String ipAddr;
        long objHash;
        MapPack paramPack = new MapPack();
        paramPack.put("date", searchXLogRequest.getYyyymmdd());
        paramPack.put("stime", searchXLogRequest.getStartTimeMillis());
        paramPack.put("etime", searchXLogRequest.getEndTimeMillis());
        String service = searchXLogRequest.getService();
        if (service != null) {
            paramPack.put("service", service);
        }
        if ((objHash = searchXLogRequest.getObjHash()) != 0L) {
            paramPack.put("objHash", objHash);
        }
        if ((ipAddr = searchXLogRequest.getIp()) != null) {
            paramPack.put("ip", ipAddr);
        }
        if ((login = searchXLogRequest.getLogin()) != null) {
            paramPack.put("login", login);
        }
        if ((desc = searchXLogRequest.getDesc()) != null) {
            paramPack.put("desc", desc);
        }
        if ((textTemp = searchXLogRequest.getText1()) != null) {
            paramPack.put("text1", textTemp);
        }
        if ((textTemp = searchXLogRequest.getText2()) != null) {
            paramPack.put("text2", textTemp);
        }
        if ((textTemp = searchXLogRequest.getText3()) != null) {
            paramPack.put("text3", textTemp);
        }
        if ((textTemp = searchXLogRequest.getText4()) != null) {
            paramPack.put("text4", textTemp);
        }
        if ((textTemp = searchXLogRequest.getText5()) != null) {
            paramPack.put("text5", textTemp);
        }
        List<Pack> resp = null;
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(searchXLogRequest.getServerId());){
            resp = tcpProxy.process("SEARCH_XLOG_LIST", (Pack)paramPack);
        }
        return resp;
    }
}

