/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import scouter.lang.counters.CounterEngine;
import scouter.util.HashUtil;
import scouterx.webapp.framework.client.model.AgentModelThread;
import scouterx.webapp.framework.client.model.AgentObject;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.util.ZZ;
import scouterx.webapp.layer.service.ActiveServiceService;
import scouterx.webapp.layer.service.CounterService;
import scouterx.webapp.layer.service.InteractionCounterService;
import scouterx.webapp.model.InteractionCounterData;
import scouterx.webapp.model.scouter.SCounter;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/interactionCounter")
@Api(value="InteractionCounter")
@Singleton
@Produces(value={"application/json"})
public class InteractionCounterController {
    public static final String JAVAEE = "javaee";
    @Context
    HttpServletRequest servletRequest;
    static Set<String> hostCounterSet = new HashSet<String>();
    static Set<String> javaCounterSet = new HashSet<String>();
    public static final String CPU = "Cpu";
    public static final String _CPU = ":Cpu";
    public static final String ACTIVE_SPEED = "ActiveSpeed";
    public static final String _ACTIVE_SPEED = ":ActiveSpeed";
    private final InteractionCounterService service = new InteractionCounterService();
    private final CounterService counterService = new CounterService();
    private final ActiveServiceService activeServiceService = new ActiveServiceService();

    @GET
    @Path(value="/realTime/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<InteractionCounterData>> retrieveRealTimeCountersByObjType(@PathParam(value="objType") @Valid @NotNull String objType, @QueryParam(value="serverId") int serverId) {
        List<InteractionCounterData> counterList = this.service.retrieveRealTimeByObjType(objType, ServerManager.getInstance().getServerIfNullDefault(serverId));
        return CommonResultView.success(counterList);
    }

    @GET
    @Path(value="/realTime")
    @Consumes(value={"application/json"})
    public CommonResultView<List<InteractionCounterData>> retrieveRealTimeCountersByObjHashes(@QueryParam(value="objHashes") @Valid @NotNull String objHashes, @QueryParam(value="serverId") int serverId) {
        Set<Integer> objHashSet = ZZ.splitParamAsIntegerSet(objHashes);
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        List<InteractionCounterData> counterList = this.service.retrieveRealTimeByObjHashes(objHashSet, server);
        HashSet<Integer> resultObjHashSet = new HashSet<Integer>();
        for (InteractionCounterData data : counterList) {
            resultObjHashSet.add(data.fromObjHash);
            resultObjHashSet.add(data.toObjHash);
        }
        Map<String, SCounter> hostCounters = this.findHostCounters(resultObjHashSet, server);
        Map<String, SCounter> javaCounters = this.findJavaCounters(resultObjHashSet, server);
        AgentModelThread agentModel = AgentModelThread.getInstance();
        for (InteractionCounterData data : counterList) {
            AgentObject fromParent = agentModel.getAgentObject(data.fromObjHash);
            AgentObject toParent = agentModel.getAgentObject(data.toObjHash);
            data.addFromObjCounter(hostCounters.get(fromParent == null ? null : fromParent.getParentHash() + _CPU));
            data.addFromObjCounter(javaCounters.get(data.fromObjHash + _ACTIVE_SPEED));
            data.addToObjCounter(hostCounters.get(toParent == null ? null : toParent.getParentHash() + _CPU));
            data.addToObjCounter(javaCounters.get(data.toObjHash + _ACTIVE_SPEED));
        }
        return CommonResultView.success(counterList);
    }

    private Map<String, SCounter> findHostCounters(Set<Integer> objHashSet, Server server) {
        Map<Integer, AgentObject> agentObjectMap = AgentModelThread.getInstance().getAgentObjectMap();
        Set<Integer> parentHashes = objHashSet.stream().map(objHash -> (AgentObject)agentObjectMap.get(objHash)).filter(Objects::nonNull).map(agent -> HashUtil.hash((String)agent.getParentName())).collect(Collectors.toSet());
        List<SCounter> hostCounters = this.counterService.retrieveRealTimeCountersByObjHashes(parentHashes, hostCounterSet, server);
        return hostCounters.stream().collect(Collectors.toMap(o -> o.getObjHash() + ":" + o.getName(), o -> o));
    }

    private Map<String, SCounter> findJavaCounters(Set<Integer> objHashSet, Server server) {
        CounterEngine counterEngine = server.getCounterEngine();
        Map<Integer, AgentObject> agentObjectMap = AgentModelThread.getInstance().getAgentObjectMap();
        Set<Integer> javaHashes = objHashSet.stream().map(objHash -> (AgentObject)agentObjectMap.get(objHash)).filter(Objects::nonNull).filter(agent -> JAVAEE.equals(counterEngine.getFamilyNameFromObjType(agent.getObjType()))).map(agent -> agent.getObjHash()).collect(Collectors.toSet());
        List<SCounter> javaCounters = this.counterService.retrieveRealTimeCountersByObjHashes(javaHashes, javaCounterSet, server);
        return javaCounters.stream().collect(Collectors.toMap(o -> o.getObjHash() + ":" + o.getName(), o -> o));
    }

    static {
        hostCounterSet.add(CPU);
        javaCounterSet.add(ACTIVE_SPEED);
    }
}

