/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import com.fasterxml.jackson.core.JsonGenerator;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.util.IntSet;
import scouterx.webapp.framework.cache.XLogLoopCache;
import scouterx.webapp.framework.client.model.TextModel;
import scouterx.webapp.framework.client.net.INetReader;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.layer.service.XLogService;
import scouterx.webapp.model.XLogData;
import scouterx.webapp.model.XLogPackWrapper;
import scouterx.webapp.request.GxidXLogRequest;
import scouterx.webapp.request.MultiXLogRequest;
import scouterx.webapp.request.PageableXLogRequest;
import scouterx.webapp.request.RealTimeXLogDataRequest;
import scouterx.webapp.request.SearchXLogRequest;
import scouterx.webapp.request.SingleXLogRequest;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/xlog-data")
@Api(value="XLog data")
@Singleton
@Produces(value={"application/json"})
public class XLogDataController {
    private static final Logger log = LoggerFactory.getLogger(XLogDataController.class);
    private static final long WAITING_DELAY_FOR_DICTIONARY_COMPLETE = 2000L;
    private final XLogService xLogService = new XLogService();

    @GET
    @Path(value="/realTime/{offset1}/{offset2}")
    public Response streamRealTimeXLog(@BeanParam @Valid RealTimeXLogDataRequest xLogRequest) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(xLogRequest.getServerId());
        IntSet objHashSet = new IntSet();
        for (Integer objHash : xLogRequest.getObjHashes()) {
            objHashSet.add(objHash.intValue());
        }
        Consumer<JsonGenerator> realTimeXLogHandlerConsumer = jsonGenerator -> {
            try {
                XLogCountBucket countBucket = new XLogCountBucket();
                countBucket.setLoop(xLogRequest.getXLogLoop());
                countBucket.setIndex(xLogRequest.getXLogIndex());
                jsonGenerator.writeArrayFieldStart("xlogs");
                XLogLoopCache.getOf(server.getId()).getAndHandleRealTimeXLog(objHashSet, xLogRequest.getXLogLoop(), xLogRequest.getXLogIndex(), 10000, 2000L, this.getRealTimeXLogReader((JsonGenerator)jsonGenerator, countBucket, server));
                jsonGenerator.writeEndArray();
                jsonGenerator.writeNumberField("offset1", countBucket.getLoop());
                jsonGenerator.writeNumberField("offset2", countBucket.getIndex());
                jsonGenerator.writeNumberField("count", countBucket.getCount());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        TextModel.startScope();
        StreamingOutput streamingOutput = outputStream -> CommonResultView.jsonStream(outputStream, realTimeXLogHandlerConsumer);
        return Response.ok().entity((Object)streamingOutput).type("application/json").build();
    }

    @GET
    @Path(value="/{yyyymmdd}")
    @Consumes(value={"application/json"})
    public Response streamPageableXLog(@Valid @BeanParam PageableXLogRequest xLogRequest) throws ParseException {
        xLogRequest.validate();
        Server server = ServerManager.getInstance().getServerIfNullDefault(xLogRequest.getServerId());
        Consumer<JsonGenerator> pageableXLogHandlerConsumer = jsonGenerator -> {
            try {
                jsonGenerator.writeArrayFieldStart("xlogs");
                this.xLogService.handlePageableXLog(xLogRequest, this.getPageableXLogReader((JsonGenerator)jsonGenerator, server.getId()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        TextModel.startScope();
        StreamingOutput streamingOutput = outputStream -> CommonResultView.jsonStream(outputStream, pageableXLogHandlerConsumer);
        return Response.ok().entity((Object)streamingOutput).type("application/json").build();
    }

    @GET
    @Path(value="/{yyyymmdd}/{txid}")
    @Consumes(value={"application/json"})
    public CommonResultView<XLogData> retrieveSingleXLog(@Valid @BeanParam SingleXLogRequest singleXlogRequest) {
        singleXlogRequest.validate();
        XLogData xLogData = this.xLogService.retrieveSingleXLogData(singleXlogRequest);
        return CommonResultView.success(xLogData);
    }

    @GET
    @Path(value="/{yyyymmdd}/multi/{txidList}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<XLogData>> retrieveXLogDataListByTxids(@Valid @BeanParam MultiXLogRequest multiXLogRequest) {
        List<XLogData> xLogs = this.xLogService.retrieveXLogDataListByTxids(multiXLogRequest);
        return CommonResultView.success(xLogs);
    }

    @GET
    @Path(value="/{yyyymmdd}/gxid/{gxid}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<XLogData>> retrieveXLogDataListByGxid(@Valid @BeanParam GxidXLogRequest gxidRequest) {
        gxidRequest.validate();
        List<XLogData> xLogs = this.xLogService.retrieveXLogDataListByGxid(gxidRequest);
        return CommonResultView.success(xLogs);
    }

    @GET
    @Path(value="/search/{yyyymmdd}")
    @Consumes(value={"application/json"})
    public CommonResultView<List> searchXLog(@Valid @BeanParam SearchXLogRequest xLogRequest) throws ParseException {
        xLogRequest.validate();
        TextModel.startScope();
        List<XLogData> list = this.xLogService.searchXLogDataList(xLogRequest);
        TextModel.endScope();
        return CommonResultView.success(list);
    }

    private Consumer<XLogPackWrapper> getRealTimeXLogReader(JsonGenerator jsonGenerator, XLogCountBucket countBucket, Server server) {
        return xLogPackWrapper -> {
            try {
                jsonGenerator.writeObject((Object)XLogData.of(xLogPackWrapper.getPack(), server.getId()));
                countBucket.setCount(countBucket.getCount() + 1);
                countBucket.setLoop(xLogPackWrapper.getLoop());
                countBucket.setIndex(xLogPackWrapper.getIndex());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private INetReader getPageableXLogReader(JsonGenerator jsonGenerator, int serverId) {
        int[] countable = new int[]{0};
        return in -> {
            Pack p = in.readPack();
            if (p.getPackType() != 10) {
                XLogPack xLogPack = (XLogPack)p;
                jsonGenerator.writeObject((Object)XLogData.of(xLogPack, serverId));
                countable[0] = countable[0] + 1;
            } else {
                jsonGenerator.writeEndArray();
                MapPack metaPack = (MapPack)p;
                jsonGenerator.writeBooleanField("hasMore", metaPack.getBoolean("hasMore"));
                jsonGenerator.writeNumberField("lastTxid", metaPack.getLong("lastTxid"));
                jsonGenerator.writeNumberField("lastXLogTime", metaPack.getLong("lastXLogTime"));
                jsonGenerator.writeNumberField("count", countable[0]);
            }
        };
    }

    private static class XLogCountBucket {
        int count;
        long loop;
        int index;

        private int getCount() {
            return this.count;
        }

        private void setCount(int count) {
            this.count = count;
        }

        private long getLoop() {
            return this.loop;
        }

        private void setLoop(long loop) {
            this.loop = loop;
        }

        private int getIndex() {
            return this.index;
        }

        private void setIndex(int index) {
            this.index = index;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XLogCountBucket)) {
                return false;
            }
            XLogCountBucket other = (XLogCountBucket)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            if (this.getLoop() != other.getLoop()) {
                return false;
            }
            return this.getIndex() == other.getIndex();
        }

        protected boolean canEqual(Object other) {
            return other instanceof XLogCountBucket;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCount();
            long $loop = this.getLoop();
            result = result * 59 + (int)($loop >>> 32 ^ $loop);
            result = result * 59 + this.getIndex();
            return result;
        }

        public String toString() {
            return "XLogDataController.XLogCountBucket(count=" + this.getCount() + ", loop=" + this.getLoop() + ", index=" + this.getIndex() + ")";
        }
    }
}

