/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model.countermodel;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import scouter.lang.Counter;
import scouter.lang.Family;
import scouter.lang.ObjectType;
import scouter.lang.counters.CounterEngine;
import scouter.util.StringKeyLinkedMap;
import scouterx.webapp.model.countermodel.CounterData;
import scouterx.webapp.model.countermodel.FamilyData;
import scouterx.webapp.model.countermodel.ObjectTypeData;

public class CounterModelData {
    List<FamilyData> families;
    List<ObjectTypeData> objTypes;

    public static CounterModelData of(CounterEngine engine) {
        CounterModelData counterModelData = new CounterModelData();
        counterModelData.families = CounterModelData.makeFamilies(engine);
        counterModelData.objTypes = CounterModelData.makeObjTypes(engine);
        return counterModelData;
    }

    private static List<FamilyData> makeFamilies(CounterEngine engine) {
        ArrayList<FamilyData> families = new ArrayList<FamilyData>();
        StringKeyLinkedMap familyMap = engine.getRawFamilyMap();
        Enumeration familyEnumeration = familyMap.values();
        while (familyEnumeration.hasMoreElements()) {
            Family family = (Family)familyEnumeration.nextElement();
            FamilyData familyData = new FamilyData(family.getName());
            for (Counter counter : family.listCounters()) {
                boolean isMasterCounter = false;
                if (counter.getName().equals(family.getMaster())) {
                    isMasterCounter = true;
                }
                CounterData counterData = CounterData.builder().name(counter.getName()).displayName(counter.getDisplayName()).unit(counter.getUnit()).totalizable(counter.isTotal()).icon(counter.getIcon()).isMaster(isMasterCounter).build();
                familyData.addCounterData(counterData);
            }
            families.add(familyData);
        }
        return families;
    }

    private static List<ObjectTypeData> makeObjTypes(CounterEngine engine) {
        ArrayList<ObjectTypeData> objTypes = new ArrayList<ObjectTypeData>();
        StringKeyLinkedMap objTypeMap = engine.getRawObjectTypeMap();
        Enumeration objTypeEnumeration = objTypeMap.values();
        while (objTypeEnumeration.hasMoreElements()) {
            ObjectType objType = (ObjectType)objTypeEnumeration.nextElement();
            ObjectTypeData objectTypeData = ObjectTypeData.builder().name(objType.getName()).displayName(objType.getDisplayName()).familyName(objType.getFamily().getName()).isSubObject(objType.isSubObject()).icon(objType.getIcon()).build();
            objTypes.add(objectTypeData);
        }
        return objTypes;
    }

    public List<FamilyData> getFamilies() {
        return this.families;
    }

    public List<ObjectTypeData> getObjTypes() {
        return this.objTypes;
    }
}

