/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model.scouter;

import java.util.ArrayList;
import java.util.List;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.StringUtil;
import scouterx.webapp.framework.client.model.AgentModelThread;
import scouterx.webapp.framework.client.model.AgentObject;
import scouterx.webapp.model.enums.ActiveServiceMode;

public class SActiveService {
    int objHash;
    String objName;
    long threadId;
    String threadName;
    String threadStatus;
    long threadCpuTime;
    String txidName;
    long elapsed;
    String serviceName;
    String ipaddr;
    String note;
    String mode = ActiveServiceMode.NONE.name();

    public static List<SActiveService> ofPackList(List<Pack> activeServicePackList) {
        ArrayList<SActiveService> resultList = new ArrayList<SActiveService>();
        for (Pack pack : activeServicePackList) {
            MapPack mapPack = (MapPack)pack;
            int objHash = mapPack.getInt("objHash");
            AgentObject agentObject = AgentModelThread.getInstance().getAgentObject(objHash);
            if (agentObject == null) continue;
            String objName = agentObject.getObjName();
            ListValue idLv = mapPack.getList("id");
            ListValue nameLv = mapPack.getList("name");
            ListValue statLv = mapPack.getList("stat");
            ListValue cpuLv = mapPack.getList("cpu");
            ListValue txidLv = mapPack.getList("txid");
            ListValue elapsedLv = mapPack.getList("elapsed");
            ListValue serviceLv = mapPack.getList("service");
            ListValue ipLv = mapPack.getList("ip");
            ListValue sqlLv = mapPack.getList("sql");
            ListValue subcallLv = mapPack.getList("subcall");
            if (idLv != null) {
                int size = idLv.size();
                for (int i = 0; i < size; ++i) {
                    SActiveService activeService = new SActiveService();
                    activeService.objHash = objHash;
                    activeService.objName = objName;
                    activeService.threadId = idLv.getLong(i);
                    activeService.threadName = nameLv.getString(i);
                    activeService.threadStatus = statLv.getString(i);
                    activeService.threadCpuTime = cpuLv.getLong(i);
                    activeService.txidName = txidLv.getString(i);
                    activeService.elapsed = elapsedLv.getLong(i);
                    activeService.serviceName = serviceLv.getString(i);
                    String sql = sqlLv.getString(i);
                    String api = subcallLv.getString(i);
                    if (StringUtil.isNotEmpty((String)sql)) {
                        activeService.note = sql;
                        activeService.mode = ActiveServiceMode.SQL.name();
                    } else if (StringUtil.isNotEmpty((String)api)) {
                        activeService.note = api;
                        activeService.mode = ActiveServiceMode.SUBCALL.name();
                    }
                    if (ipLv != null) {
                        activeService.ipaddr = ipLv.getString(i);
                    }
                    resultList.add(activeService);
                }
            }
            resultList.sort((s1, s2) -> s1.elapsed > s2.elapsed ? -1 : 1);
        }
        return resultList;
    }

    public int getObjHash() {
        return this.objHash;
    }

    public String getObjName() {
        return this.objName;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getThreadStatus() {
        return this.threadStatus;
    }

    public long getThreadCpuTime() {
        return this.threadCpuTime;
    }

    public String getTxidName() {
        return this.txidName;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getIpaddr() {
        return this.ipaddr;
    }

    public String getNote() {
        return this.note;
    }

    public String getMode() {
        return this.mode;
    }

    public void setObjHash(int objHash) {
        this.objHash = objHash;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public void setThreadStatus(String threadStatus) {
        this.threadStatus = threadStatus;
    }

    public void setThreadCpuTime(long threadCpuTime) {
        this.threadCpuTime = threadCpuTime;
    }

    public void setTxidName(String txidName) {
        this.txidName = txidName;
    }

    public void setElapsed(long elapsed) {
        this.elapsed = elapsed;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setIpaddr(String ipaddr) {
        this.ipaddr = ipaddr;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SActiveService)) {
            return false;
        }
        SActiveService other = (SActiveService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getObjHash() != other.getObjHash()) {
            return false;
        }
        String this$objName = this.getObjName();
        String other$objName = other.getObjName();
        if (this$objName == null ? other$objName != null : !this$objName.equals(other$objName)) {
            return false;
        }
        if (this.getThreadId() != other.getThreadId()) {
            return false;
        }
        String this$threadName = this.getThreadName();
        String other$threadName = other.getThreadName();
        if (this$threadName == null ? other$threadName != null : !this$threadName.equals(other$threadName)) {
            return false;
        }
        String this$threadStatus = this.getThreadStatus();
        String other$threadStatus = other.getThreadStatus();
        if (this$threadStatus == null ? other$threadStatus != null : !this$threadStatus.equals(other$threadStatus)) {
            return false;
        }
        if (this.getThreadCpuTime() != other.getThreadCpuTime()) {
            return false;
        }
        String this$txidName = this.getTxidName();
        String other$txidName = other.getTxidName();
        if (this$txidName == null ? other$txidName != null : !this$txidName.equals(other$txidName)) {
            return false;
        }
        if (this.getElapsed() != other.getElapsed()) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$ipaddr = this.getIpaddr();
        String other$ipaddr = other.getIpaddr();
        if (this$ipaddr == null ? other$ipaddr != null : !this$ipaddr.equals(other$ipaddr)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        if (this$note == null ? other$note != null : !this$note.equals(other$note)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SActiveService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getObjHash();
        String $objName = this.getObjName();
        result = result * 59 + ($objName == null ? 43 : $objName.hashCode());
        long $threadId = this.getThreadId();
        result = result * 59 + (int)($threadId >>> 32 ^ $threadId);
        String $threadName = this.getThreadName();
        result = result * 59 + ($threadName == null ? 43 : $threadName.hashCode());
        String $threadStatus = this.getThreadStatus();
        result = result * 59 + ($threadStatus == null ? 43 : $threadStatus.hashCode());
        long $threadCpuTime = this.getThreadCpuTime();
        result = result * 59 + (int)($threadCpuTime >>> 32 ^ $threadCpuTime);
        String $txidName = this.getTxidName();
        result = result * 59 + ($txidName == null ? 43 : $txidName.hashCode());
        long $elapsed = this.getElapsed();
        result = result * 59 + (int)($elapsed >>> 32 ^ $elapsed);
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $ipaddr = this.getIpaddr();
        result = result * 59 + ($ipaddr == null ? 43 : $ipaddr.hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        return result;
    }

    public String toString() {
        return "SActiveService(objHash=" + this.getObjHash() + ", objName=" + this.getObjName() + ", threadId=" + this.getThreadId() + ", threadName=" + this.getThreadName() + ", threadStatus=" + this.getThreadStatus() + ", threadCpuTime=" + this.getThreadCpuTime() + ", txidName=" + this.getTxidName() + ", elapsed=" + this.getElapsed() + ", serviceName=" + this.getServiceName() + ", ipaddr=" + this.getIpaddr() + ", note=" + this.getNote() + ", mode=" + this.getMode() + ")";
    }
}

