/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model.scouter.step;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import scouter.lang.step.CommonSpanStep;
import scouter.lang.step.StepSingle;
import scouter.lang.value.Value;
import scouter.util.IPUtil;

public abstract class SCommonSpanStep
extends StepSingle {
    public int hash;
    public int elapsed;
    public int error;
    public long timestamp;
    public byte spanType;
    public Endpoint localEndpoint;
    public Endpoint remoteEndpoint;
    public boolean debug;
    public boolean shared;
    public List<SpanAnnotation> annotations;
    public Map<String, String> tags;

    public void setProps(CommonSpanStep org) {
        this.parent = org.getParent();
        this.index = org.getIndex();
        this.start_time = org.getStart_time();
        this.hash = org.getHash();
        this.elapsed = org.getElapsed();
        this.error = org.getError();
        this.timestamp = org.getTimestamp();
        this.spanType = org.spanType;
        this.localEndpoint = new Endpoint(org.getLocalEndpointServiceName(), IPUtil.toString((byte[])org.getLocalEndpointIp()), org.getLocalEndpointPort());
        this.remoteEndpoint = new Endpoint(org.getRemoteEndpointServiceName(), IPUtil.toString((byte[])org.getRemoteEndpointIp()), org.getRemoteEndpointPort());
        this.debug = org.debug;
        this.shared = org.shared;
        this.annotations = new ArrayList<SpanAnnotation>();
        for (int i = 0; i < org.annotationTimestamps.size(); ++i) {
            this.annotations.add(new SpanAnnotation(org.getAnnotationTimestamps().getLong(i), org.getAnnotationValues().getString(i)));
        }
        this.tags = new HashMap<String, String>();
        for (Map.Entry entry : org.tags.toMap().entrySet()) {
            this.tags.put((String)entry.getKey(), ((Value)entry.getValue()).toString());
        }
    }

    public int getHash() {
        return this.hash;
    }

    public int getElapsed() {
        return this.elapsed;
    }

    public int getError() {
        return this.error;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte getSpanType() {
        return this.spanType;
    }

    public Endpoint getLocalEndpoint() {
        return this.localEndpoint;
    }

    public Endpoint getRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isShared() {
        return this.shared;
    }

    public List<SpanAnnotation> getAnnotations() {
        return this.annotations;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public static class Endpoint {
        int hash;
        String serviceName;
        String ip;
        int port;

        public Endpoint(int hash, String ip, int port) {
            this.hash = hash;
            this.ip = ip;
            this.port = port;
        }

        public int getHash() {
            return this.hash;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getIp() {
            return this.ip;
        }

        public int getPort() {
            return this.port;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }
    }

    public static class SpanAnnotation {
        long timestamp;
        String value;

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getValue() {
            return this.value;
        }

        @ConstructorProperties(value={"timestamp", "value"})
        public SpanAnnotation(long timestamp, String value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }
}

