/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model.summary;

import java.util.List;
import scouter.lang.value.ListValue;
import scouter.util.DateTimeHelper;
import scouterx.webapp.framework.client.model.TextProxy;
import scouterx.webapp.framework.dto.DateAndMapPack;
import scouterx.webapp.model.summary.Summary;
import scouterx.webapp.model.summary.SummaryItem;

public class SqlSummaryItem
extends SummaryItem<SqlSummaryItem> {
    private int errorCount;
    private long elapsedSum;

    public SqlSummaryItem(int summaryKey, String summaryKeyName, int count, int errorCount, long elapsedSum) {
        this.summaryKey = summaryKey;
        this.summaryKeyName = summaryKeyName;
        this.count = count;
        this.errorCount = errorCount;
        this.elapsedSum = elapsedSum;
    }

    @Override
    public void merge(SqlSummaryItem newItem) {
        this.setCount(this.getCount() + newItem.getCount());
        this.setErrorCount(this.getErrorCount() + newItem.getErrorCount());
        this.setElapsedSum(this.getElapsedSum() + newItem.getElapsedSum());
    }

    @Override
    public Summary<SqlSummaryItem> toSummary(List<DateAndMapPack> dnmPackList, int serverId) {
        Summary<SqlSummaryItem> summary = new Summary<SqlSummaryItem>();
        for (DateAndMapPack dnmPack : dnmPackList) {
            long date = DateTimeHelper.getDefault().yyyymmdd(dnmPack.getYyyymmdd());
            ListValue idList = dnmPack.getMapPack().getList("id");
            ListValue countList = dnmPack.getMapPack().getList("count");
            ListValue errorCntList = dnmPack.getMapPack().getList("error");
            ListValue elapsedSumList = dnmPack.getMapPack().getList("elapsed");
            for (int i = 0; i < idList.size(); ++i) {
                SqlSummaryItem item = SqlSummaryItem.builder().summaryKey(idList.getInt(i)).summaryKeyName(TextProxy.sql.getTextIfNullDefault(date, idList.getInt(i), serverId)).count(countList.getInt(i)).errorCount(errorCntList.getInt(i)).elapsedSum(elapsedSumList.getLong(i)).build();
                summary.merge(item);
            }
        }
        return summary;
    }

    public static SqlSummaryItemBuilder builder() {
        return new SqlSummaryItemBuilder();
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public long getElapsedSum() {
        return this.elapsedSum;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public void setElapsedSum(long elapsedSum) {
        this.elapsedSum = elapsedSum;
    }

    @Override
    public String toString() {
        return "SqlSummaryItem(errorCount=" + this.getErrorCount() + ", elapsedSum=" + this.getElapsedSum() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlSummaryItem)) {
            return false;
        }
        SqlSummaryItem other = (SqlSummaryItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getErrorCount() != other.getErrorCount()) {
            return false;
        }
        return this.getElapsedSum() == other.getElapsedSum();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SqlSummaryItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.getErrorCount();
        long $elapsedSum = this.getElapsedSum();
        result = result * 59 + (int)($elapsedSum >>> 32 ^ $elapsedSum);
        return result;
    }

    public SqlSummaryItem() {
    }

    public static class SqlSummaryItemBuilder {
        private int summaryKey;
        private String summaryKeyName;
        private int count;
        private int errorCount;
        private long elapsedSum;

        SqlSummaryItemBuilder() {
        }

        public SqlSummaryItemBuilder summaryKey(int summaryKey) {
            this.summaryKey = summaryKey;
            return this;
        }

        public SqlSummaryItemBuilder summaryKeyName(String summaryKeyName) {
            this.summaryKeyName = summaryKeyName;
            return this;
        }

        public SqlSummaryItemBuilder count(int count) {
            this.count = count;
            return this;
        }

        public SqlSummaryItemBuilder errorCount(int errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public SqlSummaryItemBuilder elapsedSum(long elapsedSum) {
            this.elapsedSum = elapsedSum;
            return this;
        }

        public SqlSummaryItem build() {
            return new SqlSummaryItem(this.summaryKey, this.summaryKeyName, this.count, this.errorCount, this.elapsedSum);
        }

        public String toString() {
            return "SqlSummaryItem.SqlSummaryItemBuilder(summaryKey=" + this.summaryKey + ", summaryKeyName=" + this.summaryKeyName + ", count=" + this.count + ", errorCount=" + this.errorCount + ", elapsedSum=" + this.elapsedSum + ")";
        }
    }
}

