/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.request;

import javax.validation.constraints.NotNull;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.framework.exception.ErrorState;

public class GxidXLogRequest {
    int serverId;
    @NotNull
    @PathParam(value="gxid")
    private long gxid;
    @NotNull
    @PathParam(value="yyyymmdd")
    String yyyymmdd;

    @QueryParam(value="serverId")
    public void setServerId(int serverId) {
        this.serverId = ServerManager.getInstance().getServerIfNullDefault(serverId).getId();
    }

    public void validate() {
        if (0L == this.gxid || "".equals(this.yyyymmdd)) {
            throw ErrorState.VALIDATE_ERROR.newBizException("gxid and yyyymmdd must coexist!");
        }
    }

    public int getServerId() {
        return this.serverId;
    }

    public long getGxid() {
        return this.gxid;
    }

    public String getYyyymmdd() {
        return this.yyyymmdd;
    }

    public void setGxid(long gxid) {
        this.gxid = gxid;
    }

    public void setYyyymmdd(String yyyymmdd) {
        this.yyyymmdd = yyyymmdd;
    }
}

