/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.request;

import javax.validation.constraints.NotNull;
import javax.ws.rs.PathParam;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.request.CounterRequestByType;
import scouterx.webapp.request.LatestCounterRequest;

public class LatestCounterRequestByType
extends LatestCounterRequest {
    @NotNull
    @PathParam(value="objType")
    private String objType;

    public CounterRequestByType toCounterRequestByType() {
        CounterRequestByType toType = new CounterRequestByType();
        toType.setObjType(this.objType);
        toType.setServerId(this.getServerId());
        toType.setCounter(this.getCounter());
        Server server = ServerManager.getInstance().getServerIfNullDefault(this.getServerId());
        long end = server.getCurrentTime();
        long start = end - (long)(this.getLatestSec() * 1000);
        toType.setStartTimeMillis(start);
        toType.setEndTimeMillis(end);
        return toType;
    }

    public String getObjType() {
        return this.objType;
    }

    public void setObjType(String objType) {
        this.objType = objType;
    }

    @Override
    public String toString() {
        return "LatestCounterRequestByType(objType=" + this.getObjType() + ")";
    }
}

