/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.view;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;
import javax.xml.bind.annotation.XmlRootElement;
import org.slf4j.MDC;

@XmlRootElement
public class CommonResultView<T> {
    private static final int SUCCESS = 0;
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(JsonGenerator.Feature.WRITE_NUMBERS_AS_STRINGS, true);
    private int status = 200;
    private String requestId;
    private int resultCode;
    private String message;
    private T result;

    public CommonResultView() {
    }

    public CommonResultView(int resultCode, String message, T result) {
        this.resultCode = resultCode;
        this.message = message;
        this.result = result;
        this.requestId = MDC.get((String)"requestId");
    }

    public CommonResultView(int status, int resultCode, String message, T result) {
        this.status = status;
        this.resultCode = resultCode;
        this.message = message;
        this.result = result;
        this.requestId = MDC.get((String)"requestId");
    }

    public static CommonResultView<Boolean> success() {
        return new CommonResultView<Boolean>(0, "success", true);
    }

    public static <T> CommonResultView<T> success(T result) {
        return new CommonResultView<T>(0, "success", result);
    }

    public static <T> CommonResultView fail(int resultCode, String message, T result) {
        return new CommonResultView<T>(500, resultCode, message, result);
    }

    public static <T> CommonResultView fail(int status, int resultCode, String message, T result) {
        return new CommonResultView<T>(status, resultCode, message, result);
    }

    public static void jsonArrayStream(OutputStream os, Consumer<JsonGenerator> itemGenerator) throws IOException {
        JsonGenerator jg = objectMapper.getFactory().createGenerator(os);
        jg.writeStartObject();
        jg.writeNumberField("status", 200);
        jg.writeNumberField("resultCode", 0);
        jg.writeStringField("message", "");
        jg.writeArrayFieldStart("result");
        itemGenerator.accept(jg);
        jg.writeEndArray();
        jg.writeEndObject();
        jg.flush();
        jg.close();
    }

    public static void jsonStream(OutputStream os, Consumer<JsonGenerator> jsonItemgenerator) throws IOException {
        JsonGenerator jg = objectMapper.getFactory().createGenerator(os);
        jg.writeStartObject();
        jg.writeNumberField("status", 200);
        jg.writeNumberField("resultCode", 0);
        jg.writeStringField("message", "");
        jg.writeObjectFieldStart("result");
        jsonItemgenerator.accept(jg);
        jg.writeEndObject();
        jg.writeEndObject();
        jg.flush();
        jg.close();
    }

    public int getStatus() {
        return this.status;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public String getMessage() {
        return this.message;
    }

    public T getResult() {
        return this.result;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setResult(T result) {
        this.result = result;
    }
}

