/*
 * Decompiled with CFR 0.152.
 */
package scouter.boot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import scouter.boot.Boot;

public class JarUtil {
    public static File getThisJarFile() {
        String path = "";
        ClassLoader cl = JarUtil.class.getClassLoader();
        path = cl == null ? "" + ClassLoader.getSystemClassLoader().getResource(Boot.class.getName().replace('.', '/') + ".class") : "" + cl.getResource(JarUtil.class.getName().replace('.', '/') + ".class");
        if ((path = path.substring("jar:file:/".length(), path.indexOf("!"))).indexOf(58) > 0) {
            return new File(path);
        }
        return new File("/" + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unJar(File jarFile, File toDir) throws IOException {
        if (jarFile == null) {
            return;
        }
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !JarUtil.isOk(entry.getName())) continue;
                try (InputStream in = jar.getInputStream(entry);){
                    File file = new File(toDir, entry.getName());
                    file.getParentFile().mkdirs();
                    try (FileOutputStream out = new FileOutputStream(file);){
                        byte[] buf = new byte[8192];
                        int n = in.read(buf);
                        while (n >= 0) {
                            ((OutputStream)out).write(buf, 0, n);
                            n = in.read(buf);
                        }
                    }
                }
            }
        }
    }

    private static boolean isOk(String name) {
        if (name.startsWith("META-INF")) {
            return false;
        }
        if (name.startsWith("scouter/boot")) {
            return false;
        }
        return !name.endsWith(".class");
    }
}

