/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.exception.mapper;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouterx.webapp.framework.exception.ErrorState;
import scouterx.webapp.framework.exception.ErrorStateBizException;
import scouterx.webapp.framework.exception.ErrorStateException;
import scouterx.webapp.view.CommonResultView;

@Provider
public class GenericExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(GenericExceptionMapper.class);
    @Context
    UriInfo uriInfo;

    public Response toResponse(Throwable throwable) {
        if (throwable instanceof ErrorStateBizException) {
            return this.handleErrorStateBizException((ErrorStateBizException)throwable);
        }
        if (throwable instanceof ErrorStateException) {
            return this.handlerErrorStateException((ErrorStateException)throwable);
        }
        if (throwable instanceof WebApplicationException) {
            return this.handlerWebApplicationException((WebApplicationException)throwable);
        }
        return this.handleThrowable(throwable);
    }

    private Response handleThrowable(Throwable throwable) {
        String errorMessage = this.getMessageWithCause(throwable);
        CommonResultView resultView = CommonResultView.fail(500, 500, errorMessage, null);
        log.error("[WebApplicationException] {} - {}, [uri]{}", new Object[]{resultView.getStatus(), resultView.getMessage(), this.uriInfo.getPath(), throwable});
        return Response.status((int)resultView.getStatus()).entity((Object)resultView).type("application/json").build();
    }

    private Response handlerWebApplicationException(WebApplicationException throwable) {
        WebApplicationException ex = throwable;
        CommonResultView resultView = CommonResultView.fail(ex.getResponse().getStatus(), ex.getResponse().getStatus(), ex.getMessage(), null);
        log.error("[WebApplicationException] {} - {}, [uri]{}", new Object[]{resultView.getStatus(), resultView.getMessage(), this.uriInfo.getPath()});
        return Response.status((int)resultView.getStatus()).entity((Object)resultView).type("application/json").build();
    }

    private Response handlerErrorStateException(ErrorStateException throwable) {
        ErrorStateException ex = throwable;
        ErrorState errorState = ex.getErrorState();
        CommonResultView resultView = CommonResultView.fail(errorState.getStatus().getStatusCode(), errorState.getErrorCode(), errorState.getErrorMessage(), null);
        StackTraceElement lastStack = Arrays.stream(ex.getStackTrace()).findFirst().orElse(null);
        log.error("[ErrorStateException] {} - {} - {}, [uri]{} at {}", new Object[]{resultView.getStatus(), resultView.getMessage(), ex.getMessage(), this.uriInfo.getPath(), lastStack, ex});
        return Response.status((int)resultView.getStatus()).entity((Object)resultView).type("application/json").build();
    }

    private Response handleErrorStateBizException(ErrorStateBizException throwable) {
        ErrorStateBizException ex = throwable;
        ErrorState errorState = ex.getErrorState();
        String errorMessage = errorState == ErrorState.VALIDATE_ERROR ? errorState.getErrorMessage() + ex.getMessage() : errorState.getErrorMessage();
        CommonResultView resultView = CommonResultView.fail(errorState.getStatus().getStatusCode(), errorState.getErrorCode(), errorMessage, null);
        String lastStack = Arrays.stream(ex.getStackTrace()).limit(3L).map(StackTraceElement::toString).collect(Collectors.joining("\\n "));
        log.error("[ErrorStateBizException] {} - {} - {}, [uri]{} at {}", new Object[]{resultView.getStatus(), resultView.getMessage(), ex.getMessage(), this.uriInfo.getPath(), lastStack});
        return Response.status((int)resultView.getStatus()).entity((Object)resultView).type("application/json").build();
    }

    private String getMessageWithCause(Throwable throwable) {
        StringBuilder sb = new StringBuilder().append(throwable.getMessage());
        if (throwable.getCause() != null) {
            sb.append(" [caused by] ").append(throwable.getCause().getMessage());
        }
        return sb.toString();
    }
}

