/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import scouterx.webapp.framework.configure.ConfigureAdaptor;
import scouterx.webapp.framework.configure.ConfigureManager;

public class CorsFilter
implements Filter {
    ConfigureAdaptor conf;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String allowOrigin = this.conf.getNetHttpApiCorsAllowOrigin();
        String allowCredentials = this.conf.getNetHttpApiCorsAllowCredentials();
        if (StringUtils.isNotBlank((CharSequence)allowOrigin)) {
            String hostHeader;
            if ("true".equals(allowCredentials) && "*".equals(allowOrigin) && StringUtils.isNotBlank((CharSequence)(hostHeader = httpServletRequest.getHeader("origin")))) {
                allowOrigin = hostHeader;
            }
            httpServletResponse.addHeader("Access-Control-Allow-Origin", allowOrigin);
            httpServletResponse.addHeader("Access-Control-Allow-Credentials", allowCredentials);
            httpServletResponse.addHeader("Access-Control-Max-Age", "600");
            httpServletResponse.addHeader("Access-Control-Allow-Headers", "Content-Type, Authorization");
            httpServletResponse.addHeader("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE, PATCH");
            if (httpServletRequest.getMethod().equals("OPTIONS")) {
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.conf = ConfigureManager.getConfigure();
    }
}

