/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.consumer;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogProfilePack;
import scouter.lang.step.Step;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.model.ProfileStepData;
import scouterx.webapp.request.ProfileRequest;

public class ProfileConsumer {
    private static final Logger log = LoggerFactory.getLogger(ProfileConsumer.class);
    private static final int MAX_PROFILE_BLOCK = 10;

    public List<Step> retrieveProfile(ProfileRequest profileRequest) {
        return Step.toObjectList((byte[])this.retrieveProfilePack((ProfileRequest)profileRequest).profile);
    }

    public List<ProfileStepData> retrieveProfileData(ProfileRequest profileRequest) {
        XLogProfilePack pack = this.retrieveProfilePack(profileRequest);
        return ProfileStepData.toList(pack.profile, pack.time, profileRequest.getServerId());
    }

    public XLogProfilePack retrieveProfilePack(ProfileRequest profileRequest) {
        XLogProfilePack pack;
        MapPack param = new MapPack();
        param.put("date", profileRequest.getYyyymmdd());
        param.put("txid", profileRequest.getTxid());
        param.put("max", 10L);
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(profileRequest.getServerId());){
            pack = (XLogProfilePack)tcpProxy.getSingle("TRANX_PROFILE", (Pack)param);
        }
        return pack;
    }
}

