/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import scouterx.webapp.layer.service.AlertService;
import scouterx.webapp.model.alertscript.ScriptingLoadData;
import scouterx.webapp.model.alertscript.ScriptingLogStateData;
import scouterx.webapp.model.alertscript.ScriptingSaveStateData;
import scouterx.webapp.request.RealTimeAlertRequest;
import scouterx.webapp.request.SetConfigRequest;
import scouterx.webapp.view.CommonResultView;
import scouterx.webapp.view.RealTimeAlertView;

@Path(value="/v1/alert")
@Api(value="Alert")
@Singleton
@Produces(value={"application/json"})
public class AlertController {
    private final AlertService alertService = new AlertService();

    @GET
    @Path(value="/realTime/{offset1}/{offset2}")
    @Consumes(value={"application/json"})
    public CommonResultView<RealTimeAlertView> retrieveRealTimeAlert(@BeanParam @Valid RealTimeAlertRequest request) {
        return CommonResultView.success(this.alertService.retrieveRealTimeAlert(request));
    }

    @GET
    @Path(value="/scripting/{counterName}")
    @Consumes(value={"application/json"})
    public CommonResultView<ScriptingLoadData> retrieveAlertScripting(@PathParam(value="counterName") String counterName, @QueryParam(value="serverId") int serverId) {
        return CommonResultView.success(this.alertService.loadScripting(serverId, counterName));
    }

    @POST
    @Path(value="/set/config/scripting/{counterName}")
    @Consumes(value={"application/json"})
    public CommonResultView<ScriptingSaveStateData> saveConfigAlertScripting(@PathParam(value="counterName") String counterName, @QueryParam(value="serverId") int serverId, @Valid SetConfigRequest setConfigRequest) {
        return CommonResultView.success(this.alertService.setConfigScripting(serverId, counterName, setConfigRequest));
    }

    @POST
    @Path(value="/set/rule/scripting/{counterName}")
    @Consumes(value={"application/json"})
    public CommonResultView<ScriptingSaveStateData> setRuleAlertScripting(@PathParam(value="counterName") String counterName, @QueryParam(value="serverId") int serverId, @Valid SetConfigRequest setConfigRequest) {
        return CommonResultView.success(this.alertService.setRuleScripting(serverId, counterName, setConfigRequest));
    }

    @GET
    @Path(value="/read/scripting/{loop}/{index}")
    @Consumes(value={"application/json"})
    public CommonResultView<ScriptingLogStateData> readAlertScripting(@PathParam(value="loop") long loop, @PathParam(value="index") long index, @QueryParam(value="serverId") int serverId) {
        return CommonResultView.success(this.alertService.readAlertScripting(serverId, loop, index));
    }
}

