/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import java.util.List;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.layer.service.ConfigureService;
import scouterx.webapp.model.configure.ConfObjectState;
import scouterx.webapp.model.configure.ConfigureData;
import scouterx.webapp.request.SetConfigKvRequest;
import scouterx.webapp.request.SetConfigRequest;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/configure")
@Api(value="Configure")
@Singleton
@Produces(value={"application/json"})
public class ConfigureController {
    private final ConfigureService configureService = new ConfigureService();

    @GET
    @Path(value="/server")
    @Consumes(value={"application/json"})
    public CommonResultView<ConfigureData> retrieveConfig(@QueryParam(value="serverId") int serverId) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        ConfigureData configureData = this.configureService.retrieveServerConfig(server);
        return CommonResultView.success(configureData);
    }

    @GET
    @Path(value="/object/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<ConfigureData> retrieveObjectConfig(@PathParam(value="objHash") int objHash, @QueryParam(value="serverId") int serverId) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        ConfigureData configureData = this.configureService.retrieveObjectConfig(objHash, server);
        return CommonResultView.success(configureData);
    }

    @POST
    @Path(value="/set/server")
    @Consumes(value={"application/json"})
    public CommonResultView<ConfigureData> setServerConfig(@QueryParam(value="serverId") int serverId, @Valid SetConfigRequest configRequest) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        ConfigureData configureData = this.configureService.saveServerConfig(configRequest, server);
        return CommonResultView.success(configureData);
    }

    @POST
    @Path(value="/set/object/{objHash}")
    @Consumes(value={"application/json"})
    public CommonResultView<ConfigureData> setObjectConfig(@PathParam(value="objHash") int objHash, @QueryParam(value="serverId") int serverId, @Valid SetConfigRequest configRequest) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        ConfigureData configureData = this.configureService.saveObjectConfig(configRequest, objHash, server);
        return CommonResultView.success(configureData);
    }

    @PUT
    @Path(value="/set/kv/server")
    @Consumes(value={"application/json"})
    public CommonResultView<Boolean> setKVServerConfig(@QueryParam(value="serverId") int serverId, @Valid SetConfigKvRequest configRequest) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        boolean settingState = this.configureService.saveKVServerConfig(configRequest, server);
        return CommonResultView.success(settingState);
    }

    @PUT
    @Path(value="/set/kv/ofType/{objType}")
    @Consumes(value={"application/json"})
    public CommonResultView<List<ConfObjectState>> setKVObjectConfig(@PathParam(value="objType") String objType, @QueryParam(value="serverId") int serverId, @Valid SetConfigKvRequest configRequest) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        List<ConfObjectState> resultList = this.configureService.saveObjTypConfig(objType, server, configRequest);
        return CommonResultView.success(resultList);
    }
}

