/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import scouter.lang.pack.MapPack;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.DoubleValue;
import scouter.lang.value.FloatValue;
import scouter.lang.value.TextValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.SortUtil;
import scouterx.webapp.model.KeyValueData;

public class ThreadContents {
    boolean serviceThread;
    int time;
    List<KeyValueData> keyValueDataList;

    public static ThreadContents of(MapPack pack) {
        ThreadContents threadContents = new ThreadContents();
        threadContents.keyValueDataList = new ArrayList<KeyValueData>();
        threadContents.time = CastUtil.cint((Object)pack.get("Service Elapsed"));
        String[] names = SortUtil.sort_string((Iterator)pack.keys(), (int)pack.size());
        boolean serviceThread = false;
        String[] stringArray = names;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String name;
            String key = name = stringArray[i];
            Value value = pack.get(key);
            if ("Stack Trace".equals(key)) {
                CastUtil.cString((Object)value);
                continue;
            }
            if (value instanceof TextValue) {
                String text = CastUtil.cString((Object)value);
                threadContents.keyValueDataList.add(new KeyValueData(key, text));
            } else if (value instanceof DecimalValue) {
                Long longValue = new Long(((DecimalValue)value).value);
                threadContents.keyValueDataList.add(new KeyValueData(key, longValue));
            } else if (value instanceof DoubleValue) {
                Double doubleValue = new Double(((DoubleValue)value).value);
                threadContents.keyValueDataList.add(new KeyValueData(key, doubleValue));
            } else if (value instanceof FloatValue) {
                Float floatValue = new Float(((FloatValue)value).value);
                threadContents.keyValueDataList.add(new KeyValueData(key, floatValue));
            }
            if (!key.startsWith("Service")) continue;
            serviceThread = true;
        }
        threadContents.serviceThread = serviceThread;
        return threadContents;
    }

    public boolean isServiceThread() {
        return this.serviceThread;
    }

    public int getTime() {
        return this.time;
    }

    public List<KeyValueData> getKeyValueDataList() {
        return this.keyValueDataList;
    }

    public void setServiceThread(boolean serviceThread) {
        this.serviceThread = serviceThread;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setKeyValueDataList(List<KeyValueData> keyValueDataList) {
        this.keyValueDataList = keyValueDataList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadContents)) {
            return false;
        }
        ThreadContents other = (ThreadContents)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isServiceThread() != other.isServiceThread()) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        List<KeyValueData> this$keyValueDataList = this.getKeyValueDataList();
        List<KeyValueData> other$keyValueDataList = other.getKeyValueDataList();
        return !(this$keyValueDataList == null ? other$keyValueDataList != null : !((Object)this$keyValueDataList).equals(other$keyValueDataList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadContents;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isServiceThread() ? 79 : 97);
        result = result * 59 + this.getTime();
        List<KeyValueData> $keyValueDataList = this.getKeyValueDataList();
        result = result * 59 + ($keyValueDataList == null ? 43 : ((Object)$keyValueDataList).hashCode());
        return result;
    }

    public String toString() {
        return "ThreadContents(serviceThread=" + this.isServiceThread() + ", time=" + this.getTime() + ", keyValueDataList=" + this.getKeyValueDataList() + ")";
    }
}

