/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model.scouter;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import scouter.lang.pack.AlertLevelEnum;
import scouter.lang.pack.AlertPack;
import scouter.lang.value.Value;
import scouterx.webapp.framework.client.model.AgentModelThread;

public class SAlert {
    public long time;
    public String objType;
    public int objHash;
    public String objName;
    public AlertLevelEnum level;
    public String title;
    public String message;
    public Map<String, Object> tagMap = new HashMap<String, Object>();

    public static SAlert of(AlertPack p) {
        Map<String, Object> tagMap = p.tags.toMap().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((Value)e.getValue()).toJavaObject()));
        String objName = AgentModelThread.getInstance().getAgentObject(p.objHash) == null ? "UNKNOWN" : AgentModelThread.getInstance().getAgentObject(p.objHash).getObjName();
        return SAlert.builder().time(p.time).objType(p.objType).objHash(p.objHash).objName(objName).level(AlertLevelEnum.of((int)p.level)).title(p.title).message(p.message).tagMap(tagMap).build();
    }

    @ConstructorProperties(value={"time", "objType", "objHash", "objName", "level", "title", "message", "tagMap"})
    SAlert(long time, String objType, int objHash, String objName, AlertLevelEnum level, String title, String message, Map<String, Object> tagMap) {
        this.time = time;
        this.objType = objType;
        this.objHash = objHash;
        this.objName = objName;
        this.level = level;
        this.title = title;
        this.message = message;
        this.tagMap = tagMap;
    }

    public static SAlertBuilder builder() {
        return new SAlertBuilder();
    }

    public long getTime() {
        return this.time;
    }

    public String getObjType() {
        return this.objType;
    }

    public int getObjHash() {
        return this.objHash;
    }

    public String getObjName() {
        return this.objName;
    }

    public AlertLevelEnum getLevel() {
        return this.level;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, Object> getTagMap() {
        return this.tagMap;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setObjType(String objType) {
        this.objType = objType;
    }

    public void setObjHash(int objHash) {
        this.objHash = objHash;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public void setLevel(AlertLevelEnum level) {
        this.level = level;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTagMap(Map<String, Object> tagMap) {
        this.tagMap = tagMap;
    }

    public static class SAlertBuilder {
        private long time;
        private String objType;
        private int objHash;
        private String objName;
        private AlertLevelEnum level;
        private String title;
        private String message;
        private Map<String, Object> tagMap;

        SAlertBuilder() {
        }

        public SAlertBuilder time(long time) {
            this.time = time;
            return this;
        }

        public SAlertBuilder objType(String objType) {
            this.objType = objType;
            return this;
        }

        public SAlertBuilder objHash(int objHash) {
            this.objHash = objHash;
            return this;
        }

        public SAlertBuilder objName(String objName) {
            this.objName = objName;
            return this;
        }

        public SAlertBuilder level(AlertLevelEnum level) {
            this.level = level;
            return this;
        }

        public SAlertBuilder title(String title) {
            this.title = title;
            return this;
        }

        public SAlertBuilder message(String message) {
            this.message = message;
            return this;
        }

        public SAlertBuilder tagMap(Map<String, Object> tagMap) {
            this.tagMap = tagMap;
            return this;
        }

        public SAlert build() {
            return new SAlert(this.time, this.objType, this.objHash, this.objName, this.level, this.title, this.message, this.tagMap);
        }

        public String toString() {
            return "SAlert.SAlertBuilder(time=" + this.time + ", objType=" + this.objType + ", objHash=" + this.objHash + ", objName=" + this.objName + ", level=" + this.level + ", title=" + this.title + ", message=" + this.message + ", tagMap=" + this.tagMap + ")";
        }
    }
}

