/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model.summary;

import java.util.List;
import scouter.lang.value.ListValue;
import scouter.util.DateTimeHelper;
import scouterx.webapp.framework.client.model.TextProxy;
import scouterx.webapp.framework.dto.DateAndMapPack;
import scouterx.webapp.model.summary.Summary;
import scouterx.webapp.model.summary.SummaryItem;

public class ServiceSummaryItem
extends SummaryItem<ServiceSummaryItem> {
    private int errorCount;
    private long elapsedSum;
    private long cpuSum;
    private long memorySum;

    public ServiceSummaryItem(int summaryKey, String summaryKeyName, int count, int errorCount, long elapsedSum, long cpuSum, long memorySum) {
        this.summaryKey = summaryKey;
        this.summaryKeyName = summaryKeyName;
        this.count = count;
        this.errorCount = errorCount;
        this.elapsedSum = elapsedSum;
        this.cpuSum = cpuSum;
        this.memorySum = memorySum;
    }

    @Override
    public void merge(ServiceSummaryItem newItem) {
        this.setCount(this.getCount() + newItem.getCount());
        this.setErrorCount(this.getErrorCount() + newItem.getErrorCount());
        this.setElapsedSum(this.getElapsedSum() + newItem.getElapsedSum());
        this.setCpuSum(this.getCpuSum() + newItem.getCpuSum());
        this.setMemorySum(this.getMemorySum() + newItem.getMemorySum());
    }

    @Override
    public Summary<ServiceSummaryItem> toSummary(List<DateAndMapPack> dnmPackList, int serverId) {
        Summary<ServiceSummaryItem> summary = new Summary<ServiceSummaryItem>();
        for (DateAndMapPack dnmPack : dnmPackList) {
            long date = DateTimeHelper.getDefault().yyyymmdd(dnmPack.getYyyymmdd());
            ListValue idList = dnmPack.getMapPack().getList("id");
            ListValue countList = dnmPack.getMapPack().getList("count");
            ListValue errorCntList = dnmPack.getMapPack().getList("error");
            ListValue elapsedSumList = dnmPack.getMapPack().getList("elapsed");
            ListValue cpuSumList = dnmPack.getMapPack().getList("cpu");
            ListValue memSumList = dnmPack.getMapPack().getList("mem");
            for (int i = 0; i < idList.size(); ++i) {
                ServiceSummaryItem item = ServiceSummaryItem.builder().summaryKey(idList.getInt(i)).summaryKeyName(TextProxy.service.getTextIfNullDefault(date, idList.getInt(i), serverId)).count(countList.getInt(i)).errorCount(errorCntList.getInt(i)).elapsedSum(elapsedSumList.getLong(i)).cpuSum(cpuSumList.getLong(i)).memorySum(memSumList.getLong(i)).build();
                summary.merge(item);
            }
        }
        return summary;
    }

    public static ServiceSummaryItemBuilder builder() {
        return new ServiceSummaryItemBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceSummaryItem)) {
            return false;
        }
        ServiceSummaryItem other = (ServiceSummaryItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getErrorCount() != other.getErrorCount()) {
            return false;
        }
        if (this.getElapsedSum() != other.getElapsedSum()) {
            return false;
        }
        if (this.getCpuSum() != other.getCpuSum()) {
            return false;
        }
        return this.getMemorySum() == other.getMemorySum();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ServiceSummaryItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.getErrorCount();
        long $elapsedSum = this.getElapsedSum();
        result = result * 59 + (int)($elapsedSum >>> 32 ^ $elapsedSum);
        long $cpuSum = this.getCpuSum();
        result = result * 59 + (int)($cpuSum >>> 32 ^ $cpuSum);
        long $memorySum = this.getMemorySum();
        result = result * 59 + (int)($memorySum >>> 32 ^ $memorySum);
        return result;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public long getElapsedSum() {
        return this.elapsedSum;
    }

    public long getCpuSum() {
        return this.cpuSum;
    }

    public long getMemorySum() {
        return this.memorySum;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public void setElapsedSum(long elapsedSum) {
        this.elapsedSum = elapsedSum;
    }

    public void setCpuSum(long cpuSum) {
        this.cpuSum = cpuSum;
    }

    public void setMemorySum(long memorySum) {
        this.memorySum = memorySum;
    }

    @Override
    public String toString() {
        return "ServiceSummaryItem(errorCount=" + this.getErrorCount() + ", elapsedSum=" + this.getElapsedSum() + ", cpuSum=" + this.getCpuSum() + ", memorySum=" + this.getMemorySum() + ")";
    }

    public ServiceSummaryItem() {
    }

    public static class ServiceSummaryItemBuilder {
        private int summaryKey;
        private String summaryKeyName;
        private int count;
        private int errorCount;
        private long elapsedSum;
        private long cpuSum;
        private long memorySum;

        ServiceSummaryItemBuilder() {
        }

        public ServiceSummaryItemBuilder summaryKey(int summaryKey) {
            this.summaryKey = summaryKey;
            return this;
        }

        public ServiceSummaryItemBuilder summaryKeyName(String summaryKeyName) {
            this.summaryKeyName = summaryKeyName;
            return this;
        }

        public ServiceSummaryItemBuilder count(int count) {
            this.count = count;
            return this;
        }

        public ServiceSummaryItemBuilder errorCount(int errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public ServiceSummaryItemBuilder elapsedSum(long elapsedSum) {
            this.elapsedSum = elapsedSum;
            return this;
        }

        public ServiceSummaryItemBuilder cpuSum(long cpuSum) {
            this.cpuSum = cpuSum;
            return this;
        }

        public ServiceSummaryItemBuilder memorySum(long memorySum) {
            this.memorySum = memorySum;
            return this;
        }

        public ServiceSummaryItem build() {
            return new ServiceSummaryItem(this.summaryKey, this.summaryKeyName, this.count, this.errorCount, this.elapsedSum, this.cpuSum, this.memorySum);
        }

        public String toString() {
            return "ServiceSummaryItem.ServiceSummaryItemBuilder(summaryKey=" + this.summaryKey + ", summaryKeyName=" + this.summaryKeyName + ", count=" + this.count + ", errorCount=" + this.errorCount + ", elapsedSum=" + this.elapsedSum + ", cpuSum=" + this.cpuSum + ", memorySum=" + this.memorySum + ")";
        }
    }
}

