/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.config.SwaggerContextService;
import io.swagger.models.Swagger;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.SecuritySchemeDefinition;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouterx.webapp.framework.configure.ConfigureAdaptor;
import scouterx.webapp.framework.configure.ConfigureManager;

public class Bootstrap
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(Bootstrap.class);
    private final String apiVersion = "1.0.0";
    private final String filterClass = "scouterx.webapp.swagger.AllAuthorizationFilterImpl";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ConfigureAdaptor scouterConf = ConfigureManager.getConfigure();
        if (!scouterConf.isNetHttpApiSwaggerEnabled()) {
            return;
        }
        BeanConfig beanConfig = new BeanConfig();
        String serverIp = scouterConf.getNetHttpApiSwaggerHostIp();
        if (StringUtils.isNotBlank((CharSequence)serverIp)) {
            beanConfig.setHost(serverIp + ":" + String.valueOf(scouterConf.getNetHttpPort()));
        }
        beanConfig.setVersion(this.apiVersion);
        beanConfig.setSchemes(new String[]{"http", "https"});
        beanConfig.setDescription("<a href='https://github.com/scouter-project/scouter/blob/master/scouter.document/tech/Web-API-Guide.md' target='_blank'> [Scouter document page] Scouter Web API Guide</a>");
        beanConfig.setTitle("Scouter HTTP APIs");
        beanConfig.setBasePath("/scouter");
        beanConfig.setResourcePackage("scouterx.webapp");
        beanConfig.setFilterClass(this.filterClass);
        beanConfig.setScan(true);
        Swagger swagger = new Swagger();
        swagger.securityDefinition("Scouter auth token", (SecuritySchemeDefinition)new ApiKeyAuthDefinition("Authorization", In.HEADER));
        new SwaggerContextService().withServletConfig(config).updateSwagger(swagger);
    }
}

