/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.client.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import scouter.lang.counters.CounterEngine;
import scouter.lang.pack.ObjectPack;
import scouter.lang.value.ListValue;
import scouter.util.ThreadUtil;
import scouterx.webapp.framework.client.model.AgentObject;
import scouterx.webapp.framework.client.net.LoginMgr;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;

public class AgentModelThread
extends Thread {
    private static AgentModelThread instance = null;
    private Map<Integer, AgentObject> agentMap = new HashMap<Integer, AgentObject>();
    ArrayList<ObjectPack> allAgentList = new ArrayList();
    private boolean existUnknownType;
    private Set<Integer> existServerSet = new HashSet<Integer>();
    private boolean brun = true;

    public static final synchronized AgentModelThread getInstance() {
        if (instance == null) {
            instance = new AgentModelThread();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName((Thread)instance));
            instance.start();
        }
        return instance;
    }

    public ArrayList<ObjectPack> getAgentPackList() {
        return this.allAgentList;
    }

    @Override
    public void run() {
        while (this.brun) {
            this.fetchObjectList();
            for (int i = 0; i < 20 && this.brun; ++i) {
                ThreadUtil.sleep((long)500L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fetchObjectList() {
        HashMap<Integer, AgentObject> tempAgentMap = new HashMap<Integer, AgentObject>();
        ArrayList objectPackList = new ArrayList();
        boolean existUnknownType = false;
        this.existServerSet.clear();
        Set<Integer> serverIdSet = ServerManager.getInstance().getOpenServerIdList();
        if (serverIdSet.size() > 0) {
            Integer[] serverIds;
            Integer[] integerArray = serverIds = serverIdSet.toArray(new Integer[serverIdSet.size()]);
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int serverId = integerArray[i];
                Server server = ServerManager.getInstance().getServer(serverId);
                if (!server.isOpen() || server.getSession() == 0L) continue;
                LoginMgr.refreshCounterEngine(server);
                CounterEngine counterEngine = server.getCounterEngine();
                TcpProxy proxy = TcpProxy.getTcpProxy(serverId);
                try {
                    ArrayList agentList = new ArrayList();
                    proxy.process("OBJECT_LIST_REAL_TIME", null, in -> {
                        ObjectPack o = (ObjectPack)in.readPack();
                        agentList.add(o);
                    });
                    objectPackList.addAll(agentList);
                    for (int i2 = 0; agentList != null && i2 < agentList.size(); ++i2) {
                        AgentObject oldAgent;
                        ObjectPack m = (ObjectPack)agentList.get(i2);
                        String objType = m.objType;
                        int objHash = m.objHash;
                        String objName = m.objName;
                        if (tempAgentMap.containsKey(objHash) && (oldAgent = (AgentObject)tempAgentMap.get(objHash)).isAlive()) continue;
                        AgentObject agentObject = new AgentObject(objType, objHash, objName, serverId);
                        tempAgentMap.put(objHash, agentObject);
                        agentObject.objPack = m;
                        if (!counterEngine.isUnknownObjectType(objType)) continue;
                        existUnknownType = true;
                    }
                    if (agentList.size() <= 0) continue;
                    this.existServerSet.add(serverId);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    TcpProxy.close(proxy);
                }
            }
        }
        this.allAgentList = objectPackList;
        this.agentMap = tempAgentMap;
        this.existUnknownType = existUnknownType;
    }

    public Set<Integer> existServerSet() {
        return this.existServerSet;
    }

    public AgentObject getAgentObject(int objHash) {
        return this.agentMap.get(objHash);
    }

    public Map<Integer, AgentObject> getAgentObjectMap() {
        return this.agentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInactiveByAll() {
        Set<Integer> serverIdSet = ServerManager.getInstance().getOpenServerIdList();
        if (serverIdSet.size() > 0) {
            Integer[] serverIds;
            Integer[] integerArray = serverIds = serverIdSet.toArray(new Integer[serverIdSet.size()]);
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int serverId = integerArray[i];
                TcpProxy proxy = TcpProxy.getTcpProxy(serverId);
                try {
                    proxy.process("OBJECT_REMOVE_INACTIVE", null);
                    continue;
                }
                finally {
                    TcpProxy.close(proxy);
                }
            }
        }
    }

    public static void removeInactiveByServerId(int serverId) {
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        TcpProxy proxy = TcpProxy.getTcpProxy(server.getId());
        try {
            proxy.process("OBJECT_REMOVE_INACTIVE", null);
        }
        finally {
            TcpProxy.close(proxy);
        }
    }

    public Set<AgentObject> getAgentObjectByServerId(int serverId) {
        HashSet<AgentObject> set = new HashSet<AgentObject>();
        for (AgentObject obj : this.agentMap.values()) {
            if (serverId != obj.getServerId()) continue;
            set.add(obj);
        }
        return set;
    }

    public Set<Integer> getObjectSetByServerId(int serverId) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (AgentObject obj : this.agentMap.values()) {
            if (serverId != obj.getServerId()) continue;
            set.add(obj.objHash);
        }
        return set;
    }

    public AgentObject[] getObjectList() {
        return this.agentMap.values().toArray(new AgentObject[this.agentMap.size()]);
    }

    public Set<String> getCurrentObjTypeSet() {
        HashSet<String> typeSet = new HashSet<String>();
        Iterator<Integer> keys = this.agentMap.keySet().iterator();
        while (keys.hasNext()) {
            AgentObject agent = this.agentMap.get(keys.next());
            typeSet.add(agent.getObjType());
        }
        return typeSet;
    }

    public boolean existUnknownType() {
        return this.existUnknownType;
    }

    public Set<Integer> getObjectList(String objType) {
        HashSet<Integer> set = new HashSet<Integer>();
        Iterator<Integer> keys = this.agentMap.keySet().iterator();
        while (keys.hasNext()) {
            AgentObject agent = this.agentMap.get(keys.next());
            if (!objType.equals(agent.getObjType())) continue;
            set.add(agent.getObjHash());
        }
        return set;
    }

    public ListValue getLiveObjHashLV(int serverId, String objType) {
        ListValue lv = new ListValue();
        for (AgentObject obj : this.agentMap.values()) {
            if (serverId != obj.getServerId() || !obj.isAlive() || !objType.equals(obj.getObjType())) continue;
            lv.add((long)obj.objHash);
        }
        return lv;
    }

    public Set<String> getCurrentObjectTypeList(int serverId) {
        TreeSet<String> objectTypeList = new TreeSet<String>();
        for (AgentObject agent : this.agentMap.values()) {
            if (agent.getServerId() != serverId) continue;
            String objType = agent.getObjType();
            objectTypeList.add(objType);
        }
        return objectTypeList;
    }

    public boolean existFamilyType(int serverId, String family) {
        CounterEngine engine = ServerManager.getInstance().getServer(serverId).getCounterEngine();
        for (AgentObject agent : this.agentMap.values()) {
            if (agent.getServerId() != serverId || !engine.isChildOf(agent.getObjType(), family)) continue;
            return true;
        }
        return false;
    }

    public void shutdown() {
        this.brun = false;
    }
}

