/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.client.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.util.FileUtil;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;

public class ClientTCP {
    private static final Logger log = LoggerFactory.getLogger(ClientTCP.class);
    private Socket socket;
    private DataInputX in;
    private DataOutputX out;

    public void open(int serverId) {
        this.close();
        Server server = ServerManager.getInstance().getServer(serverId);
        if (server == null) {
            return;
        }
        try {
            this.socket = new Socket();
            this.socket.setKeepAlive(false);
            this.socket.setTcpNoDelay(true);
            this.socket.setPerformancePreferences(0, 2, 1);
            this.socket.setReuseAddress(true);
            this.socket.setSoLinger(true, 1000);
            this.socket.connect(new InetSocketAddress(server.getIp(), server.getPort()), 3000);
            this.socket.setSoTimeout(server.getSoTimeOut());
            this.in = new DataInputX(new BufferedInputStream(this.socket.getInputStream()));
            this.out = new DataOutputX(new BufferedOutputStream(this.socket.getOutputStream()));
            this.out.writeInt(-889315327);
            this.out.flush();
            log.info("Connected {} to {}:{}", new Object[]{this, server.getIp(), server.getPort()});
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            this.close();
        }
    }

    public DataOutputX getOutput() {
        return this.out;
    }

    public DataInputX getInput() {
        return this.in;
    }

    public boolean connected() {
        return this.socket != null && !this.socket.isClosed();
    }

    public void close() {
        FileUtil.close((Socket)this.socket);
        FileUtil.close((DataInputX)this.in);
        FileUtil.close((DataOutputX)this.out);
        this.socket = null;
        this.in = null;
        this.out = null;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public DataInputX getIn() {
        return this.in;
    }

    public DataOutputX getOut() {
        return this.out;
    }
}

