/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.framework.configure;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import scouter.lang.conf.ConfObserver;
import scouter.lang.conf.ConfigDesc;
import scouter.lang.conf.ConfigValueType;
import scouter.lang.conf.ConfigValueUtil;
import scouter.lang.conf.ValueType;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.util.FileUtil;
import scouter.util.StrMatch;
import scouter.util.StringEnumer;
import scouter.util.StringKeyLinkedMap;
import scouter.util.StringSet;
import scouter.util.StringUtil;
import scouter.util.ThreadUtil;
import scouterx.webapp.framework.configure.ServerConfig;

public class StandAloneConfigure
extends Thread {
    private static StandAloneConfigure instance = null;
    public static final String CONF_DIR = "./conf/";
    public boolean _trace = false;
    @ConfigDesc(value="Collector connection infos - eg) host:6100:id:pw,host2:6100:id2:pw2")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String net_collector_ip_port_id_pws = "127.0.0.1:6100:admin:admin";
    @ConfigDesc(value="size of webapp connection pool to collector")
    public int net_webapp_tcp_client_pool_size = 100;
    @ConfigDesc(value="timeout of web app connection pool to collector")
    public int net_webapp_tcp_client_pool_timeout = 60000;
    @ConfigDesc(value="So timeout of web app to collector")
    public int net_webapp_tcp_client_so_timeout = 30000;
    @ConfigDesc(value="Enable api access control by client ip")
    public boolean net_http_api_auth_ip_enabled = false;
    @ConfigDesc(value="If get api caller's ip from http header.")
    public String net_http_api_auth_ip_header_key;
    @ConfigDesc(value="Enable api access control by JSESSIONID of Cookie - get session from /user/login.")
    public boolean net_http_api_auth_session_enabled = false;
    @ConfigDesc(value="api http session timeout(sec)")
    public int net_http_api_session_timeout = 86400;
    @ConfigDesc(value="Enable api access control by Bearer token(of Authorization http header) - get access token from /user/loginGetToken.")
    public boolean net_http_api_auth_bearer_token_enabled = false;
    @ConfigDesc(value="Enable gzip response on api call")
    public boolean net_http_api_gzip_enabled = true;
    @ConfigDesc(value="api access allow ip addresses")
    @ConfigValueType(value=ValueType.COMMA_SEPARATED_VALUE)
    public String net_http_api_allow_ips = "localhost,127.0.0.1,0:0:0:0:0:0:0:1,::1";
    public Set<String> allowIpExact;
    public List<StrMatch> allowIpMatch;
    @ConfigDesc(value="HTTP service port")
    public int net_http_port = 6188;
    @ConfigDesc(value="user extension web root")
    public String net_http_extweb_dir = "./extweb";
    @ConfigDesc(value="HTTP API swagger enable option")
    public boolean net_http_api_swagger_enabled = false;
    @ConfigDesc(value="Swagger option of host's ip or domain to call APIs.")
    public String net_http_api_swagger_host_ip = "";
    @ConfigDesc(value="API CORS support for Access-Control-Allow-Origin")
    public String net_http_api_cors_allow_origin = "*";
    @ConfigDesc(value="Access-Control-Allow-Credentials")
    public String net_http_api_cors_allow_credentials = "true";
    @ConfigDesc(value="Log directory")
    public String log_dir = "./logs";
    @ConfigDesc(value="Keeping period of log")
    public int log_keep_days = 30;
    @ConfigDesc(value="temp dir")
    public String temp_dir = "./tempdata";
    private long last_load_time = -1L;
    public Properties property = new Properties();
    private boolean running = true;
    private File propertyFile;
    long last_check = 0L;

    protected static final synchronized StandAloneConfigure getInstance() {
        if (instance == null) {
            instance = new StandAloneConfigure();
            instance.setDaemon(true);
            instance.setName(ThreadUtil.getName((Thread)instance));
            instance.start();
        }
        return instance;
    }

    private StandAloneConfigure() {
        Properties p = new Properties();
        HashMap<Object, Object> args = new HashMap<Object, Object>();
        args.putAll(System.getenv());
        args.putAll(System.getProperties());
        p.putAll((Map<?, ?>)args);
        this.property = p;
        this.reload(false);
    }

    private StandAloneConfigure(boolean b) {
    }

    @Override
    public void run() {
        while (this.running) {
            this.reload(false);
            ThreadUtil.sleep((long)3000L);
        }
    }

    public File getPropertyFile() {
        if (this.propertyFile != null) {
            return this.propertyFile;
        }
        String s = System.getProperty("scouter.config", "./conf/scouter.conf");
        this.propertyFile = new File(s.trim());
        return this.propertyFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean reload(boolean force) {
        long now = System.currentTimeMillis();
        if (!force && now < this.last_check + 3000L) {
            return false;
        }
        this.last_check = now;
        File file = this.getPropertyFile();
        if (file.lastModified() == this.last_load_time) {
            return false;
        }
        this.last_load_time = file.lastModified();
        Properties temp = new Properties();
        if (file.canRead()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                temp.load(in);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    FileUtil.close(in);
                    throw throwable;
                }
                FileUtil.close((InputStream)in);
            }
            FileUtil.close((InputStream)in);
        }
        this.property = ConfigValueUtil.replaceSysProp((Properties)temp);
        this.apply();
        ConfObserver.run();
        return true;
    }

    private void apply() {
        this._trace = this.getBoolean("_trace", false);
        this.net_collector_ip_port_id_pws = this.getValue("net_collector_ip_port_id_pws", "127.0.0.1:6100:admin:admin");
        this.net_webapp_tcp_client_pool_size = this.getInt("net_webapp_tcp_client_pool_size", 100);
        this.net_webapp_tcp_client_pool_timeout = this.getInt("net_webapp_tcp_client_pool_timeout", 15000);
        this.net_http_api_auth_ip_enabled = this.getBoolean("net_http_api_auth_ip_enabled", false);
        this.net_http_api_auth_ip_header_key = this.getValue("net_http_api_auth_ip_header_key", "");
        this.net_http_api_auth_session_enabled = this.getBoolean("net_http_api_auth_session_enabled", false);
        this.net_http_api_session_timeout = this.getInt("net_http_api_session_timeout", 86400);
        this.net_http_api_auth_bearer_token_enabled = this.getBoolean("net_http_api_auth_bearer_token_enabled", false);
        this.net_http_api_gzip_enabled = this.getBoolean("net_http_api_gzip_enabled", true);
        this.net_http_api_allow_ips = this.getValue("net_http_api_allow_ips", "localhost,127.0.0.1,0:0:0:0:0:0:0:1,::1");
        this.allowIpExact = Stream.of(this.net_http_api_allow_ips.split(",")).collect(Collectors.toSet());
        this.allowIpMatch = this.allowIpExact.size() > 0 ? this.allowIpExact.stream().filter(v -> v.contains("*")).map(StrMatch::new).collect(Collectors.toList()) : Collections.emptyList();
        this.net_http_port = this.getInt("net_http_port", 6188);
        this.net_http_extweb_dir = this.getValue("net_http_extweb_dir", "./extweb");
        this.net_http_api_swagger_enabled = this.getBoolean("net_http_api_swagger_enabled", false);
        this.net_http_api_swagger_host_ip = this.getValue("net_http_api_swagger_host_ip", "");
        this.net_http_api_cors_allow_origin = this.getValue("net_http_api_cors_allow_origin", "*");
        this.net_http_api_cors_allow_credentials = this.getValue("net_http_api_cors_allow_credentials", "true");
        this.log_dir = this.getValue("log_dir", "./logs");
        this.log_keep_days = this.getInt("log_keep_days", 30);
        this.temp_dir = this.getValue("temp_dir", "./tempdata");
    }

    public List<ServerConfig> getServerConfigs() {
        List<ServerConfig> list = Stream.of(this.net_collector_ip_port_id_pws.split(",")).map(s -> {
            String[] val = s.split(":");
            return new ServerConfig(val[0], val[1], val[2], val[3]);
        }).collect(Collectors.toList());
        return list;
    }

    private StringSet getStringSet(String key, String deli) {
        StringSet set = new StringSet();
        String v = this.getValue(key);
        if (v != null) {
            String[] vv;
            for (String x : vv = StringUtil.split((String)v, (String)deli)) {
                if ((x = StringUtil.trimToEmpty((String)x)).length() <= 0) continue;
                set.put(x);
            }
        }
        return set;
    }

    public String getValue(String key) {
        return StringUtil.trim((String)this.property.getProperty(key));
    }

    public String getValue(String key, String def) {
        return StringUtil.trim((String)this.property.getProperty(key, def));
    }

    public int getInt(String key, int def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Integer.parseInt(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public int getInt(String key, int def, int min) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Math.max(Integer.parseInt(v), min);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Math.max(def, min);
    }

    public long getLong(String key, long def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Long.parseLong(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        try {
            String v = this.getValue(key);
            if (v != null) {
                return Boolean.parseBoolean(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String loadText() {
        String string;
        File file = this.getPropertyFile();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            byte[] buff = FileUtil.readAll((InputStream)fin);
            string = new String(buff);
        }
        catch (Exception exception) {
            FileUtil.close(fin);
            return null;
        }
        catch (Throwable throwable) {
            FileUtil.close(fin);
            throw throwable;
        }
        FileUtil.close((InputStream)fin);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public boolean saveText(String text) {
        boolean bl;
        File file = this.getPropertyFile();
        FileOutputStream out = null;
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            out = new FileOutputStream(file);
            ((OutputStream)out).write(text.getBytes());
            bl = true;
        }
        catch (Exception exception) {
            FileUtil.close(out);
            catch (Throwable throwable) {
                FileUtil.close(out);
                throw throwable;
            }
        }
        FileUtil.close((OutputStream)out);
        return bl;
        return false;
    }

    public void printConfig() {
        System.out.println("Configure -Dscouter.config=" + this.propertyFile);
    }

    public MapValue getKeyValueInfo() {
        StringKeyLinkedMap defMap = ConfigValueUtil.getConfigDefault((Object)new StandAloneConfigure(true));
        StringKeyLinkedMap curMap = ConfigValueUtil.getConfigDefault((Object)this);
        MapValue m = new MapValue();
        ListValue nameList = m.newList("key");
        ListValue valueList = m.newList("value");
        ListValue defList = m.newList("default");
        StringEnumer enu = defMap.keys();
        while (enu.hasMoreElements()) {
            String key = enu.nextString();
            nameList.add(key);
            valueList.add(ConfigValueUtil.toValue((Object)curMap.get(key)));
            defList.add(ConfigValueUtil.toValue((Object)defMap.get(key)));
        }
        return m;
    }

    public StringKeyLinkedMap<String> getConfigureDesc() {
        return ConfigValueUtil.getConfigDescMap((Object)this);
    }

    public StringKeyLinkedMap<ValueType> getConfigureValueType() {
        return ConfigValueUtil.getConfigValueTypeMap((Object)this);
    }
}

