/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.ObjectPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.BlobValue;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.IPUtil;
import scouter.util.StringUtil;
import scouterx.webapp.framework.client.model.TextProxy;
import scouterx.webapp.framework.client.net.TcpProxy;
import scouterx.webapp.framework.client.server.Server;
import scouterx.webapp.framework.client.server.ServerManager;
import scouterx.webapp.model.HeapHistogramData;
import scouterx.webapp.model.SocketObjectData;
import scouterx.webapp.model.ThreadObjectData;
import scouterx.webapp.model.VariableData;
import scouterx.webapp.model.scouter.SObject;

public class ObjectConsumer {
    public List<SObject> retrieveObjectList(Server server) {
        List<SObject> objectList = null;
        try (TcpProxy tcpProxy = TcpProxy.getTcpProxy(server);){
            objectList = tcpProxy.process("OBJECT_LIST_REAL_TIME", null).stream().map(p -> SObject.of((ObjectPack)p, server)).collect(Collectors.toList());
        }
        return objectList;
    }

    public List<ThreadObjectData> retrieveThreadList(int objHash, Server server) {
        ArrayList<ThreadObjectData> dataList = new ArrayList<ThreadObjectData>();
        try (TcpProxy tcp = TcpProxy.getTcpProxy(server);){
            MapPack param = new MapPack();
            param.put("objHash", (long)objHash);
            MapPack mapPack = (MapPack)tcp.getSingle("OBJECT_THREAD_LIST", (Pack)param);
            List<String> threadKeys = Arrays.asList("id", "name", "stat", "cpu", "txid", "elapsed", "service");
            HashMap<String, ListValue> threadObjectMap = new HashMap<String, ListValue>();
            threadKeys.forEach(key -> threadObjectMap.put((String)key, mapPack.getList(key)));
            int count = 0;
            if (threadObjectMap.containsKey("id")) {
                count = ((ListValue)threadObjectMap.get("id")).size();
            }
            for (int i = 0; i < count; ++i) {
                dataList.add(new ThreadObjectData(threadObjectMap, i));
            }
        }
        return dataList;
    }

    public String retrieveThreadDump(int objHash, Server server) {
        StringBuilder sb = new StringBuilder();
        try (TcpProxy tcp = TcpProxy.getTcpProxy(server);){
            MapPack param = new MapPack();
            param.put("objHash", (long)objHash);
            MapPack mpack = (MapPack)tcp.getSingle("OBJECT_THREAD_DUMP", (Pack)param);
            if (mpack != null) {
                ListValue lv = mpack.getList("threadDump");
                for (int i = 0; i < lv.size(); ++i) {
                    sb.append(lv.getString(i) + "\n");
                }
            }
        }
        return sb.toString();
    }

    public List<HeapHistogramData> retrieveHeapHistogram(int objHash, Server server) {
        ArrayList<HeapHistogramData> list = new ArrayList<HeapHistogramData>();
        try (TcpProxy tcp = TcpProxy.getTcpProxy(server);){
            MapPack param = new MapPack();
            param.put("objHash", (long)objHash);
            MapPack mpack = (MapPack)tcp.getSingle("OBJECT_HEAPHISTO", (Pack)param);
            ListValue lv = mpack.getList("heaphisto");
            for (int i = 0; i < lv.size(); ++i) {
                HeapHistogramData data = new HeapHistogramData();
                String[] tokens = StringUtil.tokenizer((String)lv.getString(i), (String)" ");
                if (tokens == null || tokens.length < 4) continue;
                String index = ObjectConsumer.removeNotDigit(tokens[0]);
                data.no = CastUtil.cint((Object)index);
                data.count = CastUtil.cint((Object)tokens[1]);
                data.size = CastUtil.clong((Object)tokens[2]);
                data.name = ObjectConsumer.getCanonicalName(tokens[3]);
                list.add(data);
            }
        }
        return list;
    }

    public List<VariableData> retrieveEnv(int objHash, Server server) {
        ArrayList<VariableData> list = null;
        try (TcpProxy tcp = TcpProxy.getTcpProxy(server);){
            MapPack param = new MapPack();
            param.put("objHash", (long)objHash);
            param.put("userSession", server.getSession());
            param.put("userIp", tcp.getLocalInetAddress().getHostAddress());
            MapPack mapPack = (MapPack)tcp.getSingle("OBJECT_ENV", (Pack)param);
            if (mapPack != null) {
                list = new ArrayList<VariableData>();
                Iterator keys = mapPack.keys();
                while (keys.hasNext()) {
                    String name = (String)keys.next();
                    String value = CastUtil.cString((Object)mapPack.get(name));
                    VariableData data = new VariableData();
                    list.add(data);
                    data.name = name;
                    data.value = value;
                }
            }
        }
        return list;
    }

    public List<SocketObjectData> retrieveSocket(int objHash, int serverId) {
        ArrayList<SocketObjectData> list = new ArrayList<SocketObjectData>();
        Server server = ServerManager.getInstance().getServerIfNullDefault(serverId);
        try (TcpProxy tcp = TcpProxy.getTcpProxy(server);){
            MapPack param = new MapPack();
            param.put("objHash", (long)objHash);
            MapPack m = (MapPack)tcp.getSingle("SOCKET", (Pack)param);
            ListValue keyLv = m.getList("key");
            ListValue hostLv = m.getList("host");
            ListValue portLv = m.getList("port");
            ListValue countLv = m.getList("count");
            ListValue serviceLv = m.getList("service");
            ListValue txidLv = m.getList("txid");
            ListValue orderLv = m.getList("order");
            ListValue stackLv = m.getList("stack");
            for (int i = 0; i < keyLv.size(); ++i) {
                SocketObjectData socketObj = new SocketObjectData();
                socketObj.key = keyLv.getLong(i);
                socketObj.host = IPUtil.toString((byte[])((BlobValue)hostLv.get((int)i)).value);
                socketObj.port = portLv.getInt(i);
                socketObj.count = countLv.getInt(i);
                socketObj.service = TextProxy.service.getTextIfNullDefault(Long.parseLong(DateUtil.yyyymmdd()), serviceLv.getInt(i), serverId);
                socketObj.txid = txidLv.getLong(i);
                socketObj.standby = orderLv.getBoolean(i);
                socketObj.stack = stackLv.getString(i);
                list.add(socketObj);
            }
        }
        return list;
    }

    private static String removeNotDigit(String name) {
        StringBuffer sb = new StringBuffer();
        char[] charArray = name.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (!Character.isDigit(charArray[i])) continue;
            sb.append(charArray[i]);
        }
        return sb.toString();
    }

    private static String getCanonicalName(String className) {
        if (StringUtil.isEmpty((String)className)) {
            return className;
        }
        int arrayCnt = 0;
        boolean prefix = true;
        char[] arr = className.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int offset = 0; offset < arr.length && prefix; ++offset) {
            if (arr[offset] == '[') {
                ++arrayCnt;
                continue;
            }
            if (offset != 0 && arr[offset - 1] != '[') continue;
            if ('L' == arr[offset]) {
                if (className.endsWith(";")) {
                    sb.append(className.substring(offset + 1, className.length() - 1));
                } else {
                    sb.append(className.substring(offset + 1));
                }
            } else if ('V' == arr[offset]) {
                sb.append("void");
            } else if ('Z' == arr[offset]) {
                sb.append("boolean");
            } else if ('C' == arr[offset]) {
                sb.append("char");
            } else if ('B' == arr[offset]) {
                sb.append("byte");
            } else if ('S' == arr[offset]) {
                sb.append("short");
            } else if ('I' == arr[offset]) {
                sb.append("int");
            } else if ('F' == arr[offset]) {
                sb.append("float");
            } else if ('J' == arr[offset]) {
                sb.append("long");
            } else if ('D' == arr[offset]) {
                sb.append("double");
            } else {
                sb.append(className);
            }
            prefix = false;
        }
        while (arrayCnt > 0) {
            sb.append("[]");
            --arrayCnt;
        }
        return sb.toString();
    }
}

