/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.controller;

import io.swagger.annotations.Api;
import java.util.List;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.ws.rs.BeanParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scouterx.webapp.layer.service.ProfileService;
import scouterx.webapp.model.ProfileStepData;
import scouterx.webapp.request.ProfileRequest;
import scouterx.webapp.view.CommonResultView;

@Path(value="/v1/profile-data")
@Api(value="Profile data")
@Singleton
@Produces(value={"application/json"})
public class ProfileDataController {
    private static final Logger log = LoggerFactory.getLogger(ProfileDataController.class);
    private final ProfileService profileService = new ProfileService();

    @GET
    @Path(value="/{yyyymmdd}/{txid}")
    public CommonResultView<List<ProfileStepData>> retrieveProfile(@BeanParam @Valid ProfileRequest profileRequest) {
        List<ProfileStepData> profileStepDataList = this.profileService.retrieveProfileData(profileRequest);
        return CommonResultView.success(profileStepDataList);
    }
}

