/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.layer.websock;

import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/basic")
public class BasicSocket {
    private static final Logger log = LoggerFactory.getLogger(BasicSocket.class);
    private Session session;
    private RemoteEndpoint.Async remote;

    @OnClose
    public void onWebSocketClose(CloseReason close) {
        this.session = null;
        this.remote = null;
        log.info("WebSocket Close: {} - {}", (Object)close.getCloseCode(), (Object)close.getReasonPhrase());
    }

    @OnOpen
    public void onWebSocketOpen(Session session) {
        this.session = session;
        this.remote = this.session.getAsyncRemote();
        log.info("WebSocket Connect: {}", (Object)session);
        this.remote.sendText("You are now connected to " + this.getClass().getName());
    }

    @OnError
    public void onWebSocketError(Throwable cause) {
        log.warn("WebSocket Error", cause);
    }

    @OnMessage
    public String onWebSocketText(String message) {
        log.info("Echoing back text message [{}]", (Object)message);
        return message;
    }
}

