/*
 * Decompiled with CFR 0.152.
 */
package scouterx.webapp.model;

import org.apache.commons.lang3.StringUtils;
import scouter.lang.pack.MapPack;
import scouterx.webapp.model.enums.ActiveServiceMode;

public class ActiveThread {
    String txidName;
    long elapsed;
    String serviceName;
    String note;
    String mode;
    long threadId;
    String threadName;
    String threadStatus;
    long threadCpuTime;
    long threadUserTime;
    long blockCount;
    long blockTime;
    long waitedCount;
    long waitedTime;
    long lockOwnerId;
    String lockName;
    String lockOwnerName;
    String stackTrace;
    String sqlActiveBindVar;

    public static ActiveThread of(MapPack pack) {
        ActiveThread activeThread = new ActiveThread();
        activeThread.txidName = pack.getText("Service Txid");
        activeThread.elapsed = pack.getLong("Service Elapsed");
        activeThread.serviceName = pack.getText("Service Name");
        String sql = pack.getText("SQL");
        String sqlBindVar = pack.getText("SQLActiveBindVar");
        String subcall = pack.getText("Subcall");
        if (StringUtils.isNotEmpty((CharSequence)sql)) {
            activeThread.note = sql;
            activeThread.mode = ActiveServiceMode.SQL.name();
        } else if (StringUtils.isNotEmpty((CharSequence)subcall)) {
            activeThread.note = subcall;
            activeThread.mode = ActiveServiceMode.SUBCALL.name();
        } else {
            activeThread.mode = ActiveServiceMode.NONE.name();
        }
        if (StringUtils.isNotEmpty((CharSequence)sqlBindVar)) {
            activeThread.sqlActiveBindVar = sqlBindVar;
        }
        activeThread.threadId = pack.getLong("Thread Id");
        activeThread.threadName = pack.getText("Thread Name");
        activeThread.threadStatus = pack.getText("State");
        activeThread.threadCpuTime = pack.getLong("Thread Cpu Time");
        activeThread.threadUserTime = pack.getLong("Thread User Time");
        activeThread.blockCount = pack.getLong("Blocked Count");
        activeThread.blockTime = pack.getLong("Blocked Time");
        activeThread.waitedCount = pack.getLong("Waited Count");
        activeThread.waitedTime = pack.getLong("Waited Time");
        activeThread.lockOwnerId = pack.getLong("Lock Owner Id");
        activeThread.lockName = pack.getText("Lock Name");
        activeThread.lockOwnerName = pack.getText("Lock Owner Name");
        activeThread.stackTrace = pack.getText("Stack Trace");
        return activeThread;
    }

    public String getTxidName() {
        return this.txidName;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getNote() {
        return this.note;
    }

    public String getMode() {
        return this.mode;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getThreadStatus() {
        return this.threadStatus;
    }

    public long getThreadCpuTime() {
        return this.threadCpuTime;
    }

    public long getThreadUserTime() {
        return this.threadUserTime;
    }

    public long getBlockCount() {
        return this.blockCount;
    }

    public long getBlockTime() {
        return this.blockTime;
    }

    public long getWaitedCount() {
        return this.waitedCount;
    }

    public long getWaitedTime() {
        return this.waitedTime;
    }

    public long getLockOwnerId() {
        return this.lockOwnerId;
    }

    public String getLockName() {
        return this.lockName;
    }

    public String getLockOwnerName() {
        return this.lockOwnerName;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public String getSqlActiveBindVar() {
        return this.sqlActiveBindVar;
    }

    public void setTxidName(String txidName) {
        this.txidName = txidName;
    }

    public void setElapsed(long elapsed) {
        this.elapsed = elapsed;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public void setThreadStatus(String threadStatus) {
        this.threadStatus = threadStatus;
    }

    public void setThreadCpuTime(long threadCpuTime) {
        this.threadCpuTime = threadCpuTime;
    }

    public void setThreadUserTime(long threadUserTime) {
        this.threadUserTime = threadUserTime;
    }

    public void setBlockCount(long blockCount) {
        this.blockCount = blockCount;
    }

    public void setBlockTime(long blockTime) {
        this.blockTime = blockTime;
    }

    public void setWaitedCount(long waitedCount) {
        this.waitedCount = waitedCount;
    }

    public void setWaitedTime(long waitedTime) {
        this.waitedTime = waitedTime;
    }

    public void setLockOwnerId(long lockOwnerId) {
        this.lockOwnerId = lockOwnerId;
    }

    public void setLockName(String lockName) {
        this.lockName = lockName;
    }

    public void setLockOwnerName(String lockOwnerName) {
        this.lockOwnerName = lockOwnerName;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void setSqlActiveBindVar(String sqlActiveBindVar) {
        this.sqlActiveBindVar = sqlActiveBindVar;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActiveThread)) {
            return false;
        }
        ActiveThread other = (ActiveThread)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$txidName = this.getTxidName();
        String other$txidName = other.getTxidName();
        if (this$txidName == null ? other$txidName != null : !this$txidName.equals(other$txidName)) {
            return false;
        }
        if (this.getElapsed() != other.getElapsed()) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        if (this$note == null ? other$note != null : !this$note.equals(other$note)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        if (this.getThreadId() != other.getThreadId()) {
            return false;
        }
        String this$threadName = this.getThreadName();
        String other$threadName = other.getThreadName();
        if (this$threadName == null ? other$threadName != null : !this$threadName.equals(other$threadName)) {
            return false;
        }
        String this$threadStatus = this.getThreadStatus();
        String other$threadStatus = other.getThreadStatus();
        if (this$threadStatus == null ? other$threadStatus != null : !this$threadStatus.equals(other$threadStatus)) {
            return false;
        }
        if (this.getThreadCpuTime() != other.getThreadCpuTime()) {
            return false;
        }
        if (this.getThreadUserTime() != other.getThreadUserTime()) {
            return false;
        }
        if (this.getBlockCount() != other.getBlockCount()) {
            return false;
        }
        if (this.getBlockTime() != other.getBlockTime()) {
            return false;
        }
        if (this.getWaitedCount() != other.getWaitedCount()) {
            return false;
        }
        if (this.getWaitedTime() != other.getWaitedTime()) {
            return false;
        }
        if (this.getLockOwnerId() != other.getLockOwnerId()) {
            return false;
        }
        String this$lockName = this.getLockName();
        String other$lockName = other.getLockName();
        if (this$lockName == null ? other$lockName != null : !this$lockName.equals(other$lockName)) {
            return false;
        }
        String this$lockOwnerName = this.getLockOwnerName();
        String other$lockOwnerName = other.getLockOwnerName();
        if (this$lockOwnerName == null ? other$lockOwnerName != null : !this$lockOwnerName.equals(other$lockOwnerName)) {
            return false;
        }
        String this$stackTrace = this.getStackTrace();
        String other$stackTrace = other.getStackTrace();
        if (this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace)) {
            return false;
        }
        String this$sqlActiveBindVar = this.getSqlActiveBindVar();
        String other$sqlActiveBindVar = other.getSqlActiveBindVar();
        return !(this$sqlActiveBindVar == null ? other$sqlActiveBindVar != null : !this$sqlActiveBindVar.equals(other$sqlActiveBindVar));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActiveThread;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $txidName = this.getTxidName();
        result = result * 59 + ($txidName == null ? 43 : $txidName.hashCode());
        long $elapsed = this.getElapsed();
        result = result * 59 + (int)($elapsed >>> 32 ^ $elapsed);
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        long $threadId = this.getThreadId();
        result = result * 59 + (int)($threadId >>> 32 ^ $threadId);
        String $threadName = this.getThreadName();
        result = result * 59 + ($threadName == null ? 43 : $threadName.hashCode());
        String $threadStatus = this.getThreadStatus();
        result = result * 59 + ($threadStatus == null ? 43 : $threadStatus.hashCode());
        long $threadCpuTime = this.getThreadCpuTime();
        result = result * 59 + (int)($threadCpuTime >>> 32 ^ $threadCpuTime);
        long $threadUserTime = this.getThreadUserTime();
        result = result * 59 + (int)($threadUserTime >>> 32 ^ $threadUserTime);
        long $blockCount = this.getBlockCount();
        result = result * 59 + (int)($blockCount >>> 32 ^ $blockCount);
        long $blockTime = this.getBlockTime();
        result = result * 59 + (int)($blockTime >>> 32 ^ $blockTime);
        long $waitedCount = this.getWaitedCount();
        result = result * 59 + (int)($waitedCount >>> 32 ^ $waitedCount);
        long $waitedTime = this.getWaitedTime();
        result = result * 59 + (int)($waitedTime >>> 32 ^ $waitedTime);
        long $lockOwnerId = this.getLockOwnerId();
        result = result * 59 + (int)($lockOwnerId >>> 32 ^ $lockOwnerId);
        String $lockName = this.getLockName();
        result = result * 59 + ($lockName == null ? 43 : $lockName.hashCode());
        String $lockOwnerName = this.getLockOwnerName();
        result = result * 59 + ($lockOwnerName == null ? 43 : $lockOwnerName.hashCode());
        String $stackTrace = this.getStackTrace();
        result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
        String $sqlActiveBindVar = this.getSqlActiveBindVar();
        result = result * 59 + ($sqlActiveBindVar == null ? 43 : $sqlActiveBindVar.hashCode());
        return result;
    }

    public String toString() {
        return "ActiveThread(txidName=" + this.getTxidName() + ", elapsed=" + this.getElapsed() + ", serviceName=" + this.getServiceName() + ", note=" + this.getNote() + ", mode=" + this.getMode() + ", threadId=" + this.getThreadId() + ", threadName=" + this.getThreadName() + ", threadStatus=" + this.getThreadStatus() + ", threadCpuTime=" + this.getThreadCpuTime() + ", threadUserTime=" + this.getThreadUserTime() + ", blockCount=" + this.getBlockCount() + ", blockTime=" + this.getBlockTime() + ", waitedCount=" + this.getWaitedCount() + ", waitedTime=" + this.getWaitedTime() + ", lockOwnerId=" + this.getLockOwnerId() + ", lockName=" + this.getLockName() + ", lockOwnerName=" + this.getLockOwnerName() + ", stackTrace=" + this.getStackTrace() + ", sqlActiveBindVar=" + this.getSqlActiveBindVar() + ")";
    }
}

