/*
 * Decompiled with CFR 0.152.
 */
package scouter.boot;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;

public class Boot {
    public static void main(String[] args) throws Throwable {
        String lib = "./lib";
        if (args.length >= 1) {
            lib = args[0];
        }
        URL[] jarfiles = Boot.getURLs(lib);
        URLClassLoader classloader = new URLClassLoader(jarfiles, Boot.class.getClassLoader());
        Thread.currentThread().setContextClassLoader(classloader);
        String mainClass = System.getProperty("main", "scouter.server.Main");
        try {
            Class<?> c = Class.forName(mainClass, true, classloader);
            Class[] argc = new Class[]{String[].class};
            Object[] argo = new Object[]{args};
            Method method = c.getDeclaredMethod("main", argc);
            method.invoke(null, argo);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            Boot.usage();
        }
    }

    private static void usage() {
        System.out.println("java -cp ./boot.jar scouter.boot.Boot [./lib] ");
    }

    private static URL[] getURLs(String path) throws IOException {
        List<File> files = new TargetDirectoryRead().read(new File(path));
        TreeMap<String, File> jars = new TreeMap<String, File>();
        for (File file : files) {
            if (file.getName().startsWith(".")) continue;
            jars.put(file.getName(), file);
        }
        URL[] urls = new URL[jars.size()];
        ArrayList v = new ArrayList(jars.values());
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = ((File)v.get(i)).toURI().toURL();
        }
        return urls;
    }

    static class TargetDirectoryRead {
        private List<File> filePathList = new ArrayList<File>();

        TargetDirectoryRead() {
        }

        public List<File> read(File file) {
            if (file.isFile()) {
                this.filePathList.add(file);
            } else if (file.isDirectory()) {
                File[] listOfFiles = file.listFiles();
                if (listOfFiles != null) {
                    Arrays.stream(listOfFiles).forEach(v -> this.read((File)v));
                } else {
                    System.out.println("[ACCESS DENIED]");
                }
            }
            return this.filePathList;
        }
    }
}

