/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import scouter.agent.batch.ClassDesc;
import scouter.agent.batch.Configure;
import scouter.agent.batch.Logger;
import scouter.agent.batch.ObjTypeDetector;
import scouter.agent.batch.asm.IASM;
import scouter.agent.batch.asm.JDBCPreparedStatementASM;
import scouter.agent.batch.asm.JDBCResultSetASM;
import scouter.agent.batch.asm.JDBCStatementASM;
import scouter.agent.batch.asm.ScouterClassWriter;
import scouter.agent.batch.asm.util.AsmUtil;
import scouter.org.objectweb.asm.AnnotationVisitor;
import scouter.org.objectweb.asm.ClassReader;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.ClassWriter;
import scouter.util.FileUtil;

public class AgentTransformer
implements ClassFileTransformer {
    private static List<String> filters = new ArrayList<String>();
    public static ThreadLocal<ClassLoader> hookingCtx = new ThreadLocal();
    private static List<IASM> asms = new ArrayList<IASM>();
    private Configure conf = Configure.getInstance();
    private Logger.FileLog bciOut;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            ClassWriter cw;
            hookingCtx.set(loader);
            if (!this.conf.sql_enabled || className == null) {
                byte[] byArray = null;
                return byArray;
            }
            if (className.startsWith("scouter/") || !this.filter(className)) {
                byte[] byArray = null;
                return byArray;
            }
            ObjTypeDetector.check(className);
            final ClassDesc classDesc = new ClassDesc();
            ClassReader cr = new ClassReader(classfileBuffer);
            cr.accept(new ClassVisitor(327680){

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    classDesc.set(version, access, name, signature, superName, interfaces);
                    super.visit(version, access, name, signature, superName, interfaces);
                }

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    classDesc.anotation = classDesc.anotation + desc;
                    return super.visitAnnotation(desc, visible);
                }
            }, 0);
            if (AsmUtil.isInterface(classDesc.access)) {
                byte[] byArray = null;
                return byArray;
            }
            classDesc.classBeingRedefined = classBeingRedefined;
            ClassVisitor cv = cw = this.getClassWriter(classDesc);
            List<IASM> workAsms = asms;
            int max = workAsms.size();
            for (int i = 0; i < max; ++i) {
                cv = workAsms.get(i).transform(cv, className, classDesc);
                if (cv == cw) continue;
                cr = new ClassReader(classfileBuffer);
                cr.accept(cv, 8);
                classfileBuffer = cw.toByteArray();
                cv = cw = this.getClassWriter(classDesc);
                if (!this.conf._log_asm_enabled) continue;
                if (this.bciOut == null) {
                    this.bciOut = new Logger.FileLog("./scouter.bci");
                }
                this.bciOut.println(className + "\t\t[" + loader + "]");
                this.dump(className, classfileBuffer);
            }
            byte[] byArray = classfileBuffer;
            return byArray;
        }
        catch (Throwable t) {
            Logger.println("A101", "Transformer Error", t);
            t.printStackTrace();
        }
        finally {
            hookingCtx.set(null);
        }
        return null;
    }

    private ClassWriter getClassWriter(ClassDesc classDesc) {
        ScouterClassWriter cw;
        switch (classDesc.version) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 196653: {
                cw = new ScouterClassWriter(1);
                break;
            }
            default: {
                cw = new ScouterClassWriter(3);
            }
        }
        return cw;
    }

    private boolean filter(String className) {
        for (String name : filters) {
            if (className.indexOf(name) < 0) continue;
            return true;
        }
        return false;
    }

    private void dump(String className, byte[] bytes) {
        String fname = "./dump/" + className.replace('/', '_') + ".class";
        FileUtil.save(fname, bytes);
    }

    static {
        asms.add(new JDBCPreparedStatementASM());
        asms.add(new JDBCStatementASM());
        asms.add(new JDBCResultSetASM());
        filters.add("Statement");
        filters.add("ResultSet");
    }
}

