/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.asm.util;

import java.util.Map;
import scouter.agent.batch.asm.util.HookingSet;
import scouter.org.objectweb.asm.MethodVisitor;
import scouter.org.objectweb.asm.Opcodes;
import scouter.org.objectweb.asm.Type;

public class AsmUtil
implements Opcodes {
    public static Type stringType = Type.getType(String.class);

    public static boolean isStatic(int access) {
        return (access & 8) != 0;
    }

    public static boolean isPublic(int access) {
        return (access & 1) != 0;
    }

    public static String makeMethodFullName(String className, String methodName, String methodSignature) {
        return new StringBuffer().append(className.replace('/', '.')).append(".").append(methodName).append(methodSignature).toString();
    }

    public static void add(Map<String, HookingSet> classSet, String klass, String method) {
        HookingSet mset = classSet.get(klass = klass.replace('.', '/'));
        if (mset == null) {
            mset = new HookingSet();
            classSet.put(klass, mset);
        }
        mset.add(method);
    }

    public static void PUSH(MethodVisitor mv, int value) {
        if (value >= -1 && value <= 5) {
            mv.visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            mv.visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            mv.visitIntInsn(17, value);
        } else {
            mv.visitLdcInsn(new Integer(value));
        }
    }

    public static void PUSH(MethodVisitor mv, boolean value) {
        mv.visitInsn(3 + (value ? 1 : 0));
    }

    public static void PUSH(MethodVisitor mv, float value) {
        if ((double)value == 0.0) {
            mv.visitInsn(11);
        } else if ((double)value == 1.0) {
            mv.visitInsn(12);
        } else if ((double)value == 2.0) {
            mv.visitInsn(13);
        } else {
            mv.visitLdcInsn(new Float(value));
        }
    }

    public static void PUSH(MethodVisitor mv, long value) {
        if (value == 0L) {
            mv.visitInsn(9);
        } else if (value == 1L) {
            mv.visitInsn(10);
        } else {
            mv.visitLdcInsn(new Long(value));
        }
    }

    public static void PUSH(MethodVisitor mv, double value) {
        if (value == 0.0) {
            mv.visitInsn(14);
        } else if (value == 1.0) {
            mv.visitInsn(15);
        } else {
            mv.visitLdcInsn(new Double(value));
        }
    }

    public static void PUSHNULL(MethodVisitor mv) {
        mv.visitInsn(1);
    }

    public static void PUSH(MethodVisitor mv, String value) {
        if (value == null) {
            mv.visitInsn(1);
        } else {
            mv.visitLdcInsn(value);
        }
    }

    public static void PUSH(MethodVisitor mv, Number value) {
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            AsmUtil.PUSH(mv, value.intValue());
        } else if (value instanceof Double) {
            AsmUtil.PUSH(mv, value.doubleValue());
        } else if (value instanceof Float) {
            AsmUtil.PUSH(mv, value.floatValue());
        } else if (value instanceof Long) {
            AsmUtil.PUSH(mv, value.longValue());
        } else {
            throw new RuntimeException("What's this: " + value);
        }
    }

    public static void PUSH(MethodVisitor mv, Character value) {
        AsmUtil.PUSH(mv, (int)value.charValue());
    }

    public static void PUSH(MethodVisitor mv, Boolean value) {
        AsmUtil.PUSH(mv, (boolean)value);
    }

    public static int getStringIdx(int access, String desc) {
        return AsmUtil.getIdxByType(access, desc, stringType);
    }

    public static int getIdxByType(int access, String desc, Type type) {
        Type[] t = Type.getArgumentTypes(desc);
        int sidx = AsmUtil.isStatic(access) ? 0 : 1;
        for (int i = 0; t != null && i < t.length; ++i) {
            if (type.equals(t[i])) {
                return sidx;
            }
            sidx += t[i].getSize();
        }
        return -1;
    }

    public static boolean isSpecial(String name) {
        return name.startsWith("<");
    }

    public static boolean isInterface(int access) {
        return (access & 0x200) != 0;
    }

    public static void loadForArrayElement(MethodVisitor mv, Type tp, int sidx) {
        switch (tp.getSort()) {
            case 1: {
                mv.visitVarInsn(21, sidx);
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                break;
            }
            case 3: {
                mv.visitVarInsn(21, sidx);
                mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                break;
            }
            case 2: {
                mv.visitVarInsn(21, sidx);
                mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                break;
            }
            case 4: {
                mv.visitVarInsn(21, sidx);
                mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                break;
            }
            case 5: {
                mv.visitVarInsn(21, sidx);
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                break;
            }
            case 7: {
                mv.visitVarInsn(22, sidx);
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                break;
            }
            case 6: {
                mv.visitVarInsn(23, sidx);
                mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                break;
            }
            case 8: {
                mv.visitVarInsn(24, sidx);
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                break;
            }
            default: {
                mv.visitVarInsn(25, sidx);
            }
        }
    }
}

