/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.dump;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import scouter.agent.batch.proxy.IToolsMain;
import scouter.agent.batch.proxy.LoaderManager;
import scouter.agent.batch.trace.TraceContext;
import scouter.util.SystemUtil;
import scouter.util.ThreadUtil;

public class ThreadDumpHandler {
    private static final String TOOLS_MAIN = "scouter.xtra.tools.ToolsMain";

    public static void processDump(File stackFile, FileWriter stackWriter, FileWriter indexWriter, String[] filters, boolean headerExists) throws Throwable {
        if (stackWriter == null) {
            return;
        }
        List<String> dumpList = ThreadDumpHandler.threadDump();
        if (dumpList == null || dumpList.size() == 0) {
            return;
        }
        String stack = ThreadDumpHandler.filter(dumpList, filters, headerExists);
        if (stack == null || stack.length() == 0) {
            return;
        }
        TraceContext.getInstance().lastStack = stack;
        indexWriter.write(new StringBuilder(50).append(System.currentTimeMillis()).append(' ').append(stackFile.length()).append(System.getProperty("line.separator")).toString());
        indexWriter.flush();
        stackWriter.write(stack);
        stackWriter.flush();
    }

    private static String filter(List<String> dumpList, String[] filters, boolean headerExists) {
        int size = dumpList.size();
        int startIndex = 0;
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder stackBuffer = new StringBuilder(4096);
        if (headerExists) {
            int ii;
            String value;
            int i;
            for (i = startIndex; i < size; ++i) {
                value = dumpList.get(i);
                stackBuffer.append(value).append(lineSeparator);
                if (value.length() != 0) continue;
                startIndex = i + 1;
                break;
            }
            boolean bSave = false;
            boolean bScouter = false;
            ArrayList<String> stack = new ArrayList<String>();
            for (i = startIndex; i < size; ++i) {
                value = dumpList.get(i);
                if (value.length() == 0) {
                    if (bSave && stack.size() > 1) {
                        for (ii = 0; ii < stack.size(); ++ii) {
                            stackBuffer.append((String)stack.get(ii)).append(lineSeparator);
                        }
                        stackBuffer.append(lineSeparator);
                    }
                    stack.clear();
                    bSave = false;
                    bScouter = false;
                    continue;
                }
                if (stack.size() == 0 && !bScouter && value.indexOf("Scouter-") >= 0) {
                    bScouter = true;
                    continue;
                }
                if (bScouter) continue;
                stack.add(value);
                if (bSave) continue;
                if (filters == null) {
                    bSave = true;
                    continue;
                }
                for (ii = 0; ii < filters.length; ++ii) {
                    if (value.indexOf(filters[ii]) < 0) continue;
                    bSave = true;
                }
            }
            if (bSave && stack.size() > 1) {
                for (ii = 0; ii < stack.size(); ++ii) {
                    stackBuffer.append((String)stack.get(ii)).append(lineSeparator);
                }
                stackBuffer.append(lineSeparator);
            }
        }
        return stackBuffer.toString();
    }

    private static List<String> threadDump() throws Throwable {
        List<String> out = null;
        if (SystemUtil.IS_JAVA_1_5 || SystemUtil.JAVA_VENDOR.startsWith("IBM")) {
            out = ThreadUtil.getThreadDumpList();
            return out;
        }
        ClassLoader loader = LoaderManager.getToolsLoader();
        if (loader == null) {
            out = ThreadUtil.getThreadDumpList();
            return out;
        }
        try {
            Class<?> c = Class.forName(TOOLS_MAIN, true, loader);
            IToolsMain toolsMain = (IToolsMain)c.newInstance();
            out = toolsMain.threadDump(0, 100000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out;
    }
}

