/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.netio.data.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import scouter.agent.batch.Configure;
import scouter.agent.batch.Logger;
import scouter.io.DataInputX;
import scouter.io.DataOutputX;
import scouter.lang.pack.Pack;
import scouter.net.NetCafe;
import scouter.util.KeyGen;

public class UdpAgent {
    public static boolean sendUdpPackToServer(String IPAddress, int port, Pack pack) {
        InetAddress server = null;
        Configure conf = Configure.getInstance();
        try {
            server = InetAddress.getByName(IPAddress);
            byte[] byteArray = new DataOutputX().writePack(pack).toByteArray();
            if (byteArray.length > conf.net_udp_packet_max_bytes) {
                return UdpAgent.sendMTU(server, port, byteArray, conf.net_udp_packet_max_bytes);
            }
            return UdpAgent.sendUdpDirect(server, port, new DataOutputX().write(NetCafe.CAFE).write(byteArray).toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean sendUdp(String ip, int port, byte[] byteArray) {
        try {
            InetAddress server = InetAddress.getByName(ip);
            return UdpAgent.sendUdp(server, port, byteArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean sendUdp(InetAddress server, int port, byte[] byteArray) {
        Configure conf = Configure.getInstance();
        try {
            if (byteArray.length > conf.net_udp_packet_max_bytes) {
                return UdpAgent.sendMTU(server, port, byteArray, conf.net_udp_packet_max_bytes);
            }
            return UdpAgent.sendUdpDirect(server, port, byteArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean sendMTU(InetAddress IPAddress, int port, byte[] data, int packetSize) {
        try {
            if (IPAddress == null) {
                return false;
            }
            long pkid = KeyGen.next();
            int availPacketSize = packetSize - 23;
            int total = data.length / availPacketSize;
            int remainder = data.length % availPacketSize;
            int num = 0;
            boolean isSuccess = true;
            int totalPacketCnt = total;
            if (remainder > 0) {
                ++totalPacketCnt;
            }
            for (num = 0; isSuccess && num < total; ++num) {
                isSuccess = UdpAgent.SendMTUDirect(IPAddress, port, pkid, totalPacketCnt, num, availPacketSize, DataInputX.get(data, num * availPacketSize, availPacketSize));
            }
            if (isSuccess && remainder > 0) {
                isSuccess = UdpAgent.SendMTUDirect(IPAddress, port, pkid, totalPacketCnt, num, remainder, DataInputX.get(data, data.length - remainder, remainder));
            }
            return isSuccess;
        }
        catch (IOException e) {
            Logger.println("A121", "UDP", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean sendUdpDirect(InetAddress IPAddress, int port, byte[] byteArray) {
        DatagramSocket datagram = null;
        try {
            datagram = new DatagramSocket();
            DatagramPacket packet = new DatagramPacket(byteArray, byteArray.length);
            packet.setAddress(IPAddress);
            packet.setPort(port);
            datagram.send(packet);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (datagram != null) {
                try {
                    datagram.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private static boolean SendMTUDirect(InetAddress IPAddress, int port, long pkid, int total, int num, int packetSize, byte[] data) throws IOException {
        Configure conf = Configure.getInstance();
        DataOutputX out = new DataOutputX();
        out.write(NetCafe.CAFE_MTU);
        out.writeInt(conf.getObjHash());
        out.writeLong(pkid);
        out.writeShort(total);
        out.writeShort(num);
        out.writeBlob(data);
        return UdpAgent.sendUdpDirect(IPAddress, port, out.toByteArray());
    }
}

