/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.trace;

import java.util.HashMap;
import scouter.agent.batch.trace.TraceContext;
import scouter.agent.batch.trace.TraceSQL;

public class LocalSQL
extends HashMap<Integer, TraceSQL> {
    private static final long serialVersionUID = 1L;
    private String currentThreadName;
    private TraceSQL currentTraceSql;
    private Thread currentThread = Thread.currentThread();

    public LocalSQL() {
        super(100);
        this.currentThreadName = this.currentThread.getName();
    }

    public TraceSQL get(String sqlText) {
        int hashValue = sqlText.hashCode();
        TraceSQL traceSql = (TraceSQL)super.get(hashValue);
        if (traceSql == null) {
            hashValue = TraceContext.getInstance().getSQLHash(sqlText, hashValue);
            traceSql = new TraceSQL();
            traceSql.hashValue = hashValue;
            super.put(hashValue, traceSql);
        }
        this.currentTraceSql = traceSql;
        return traceSql;
    }

    public TraceSQL getCurrentTraceSQL() {
        return this.currentTraceSql;
    }

    public Thread getThread() {
        return this.currentThread;
    }

    @Override
    public String toString() {
        return this.currentThreadName + ": " + super.toString();
    }
}

