/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.batch.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import scouter.agent.batch.JavaAgent;

public class ManifestUtil {
    public static void print() throws IOException {
        InputStream manifestStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
        try {
            Manifest manifest = new Manifest(manifestStream);
            Attributes attributes = manifest.getMainAttributes();
            String impVersion = attributes.getValue("Implementation-Version");
            System.out.println(attributes);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static File getToolsFile() throws Exception {
        String java_home = System.getProperty("java.home");
        File tools = new File(java_home, "../lib/tools.jar");
        if (!tools.canRead()) {
            java_home = System.getenv("JAVA_HOME");
            if (java_home == null) {
                throw new Exception("The JAVA_HOME environment variable is not defined correctly");
            }
            tools = new File(java_home, "./lib/tools.jar");
            if (!tools.canRead()) {
                throw new Exception("The JAVA_HOME environment variable is not defined correctly");
            }
        }
        return tools;
    }

    public static String getThisJarName() {
        String path = "";
        ClassLoader cl = ManifestUtil.class.getClassLoader();
        path = cl == null ? "" + ClassLoader.getSystemClassLoader().getResource(JavaAgent.class.getName().replace('.', '/') + ".class") : "" + cl.getResource(JavaAgent.class.getName().replace('.', '/') + ".class");
        if ((path = path.substring("jar:file:/".length(), path.indexOf("!"))).indexOf(58) > 0) {
            return path;
        }
        return "/" + path;
    }
}

