/*
 * Decompiled with CFR 0.152.
 */
package scouter.util;

import scouter.extlib.com.google.common.primitives.UnsignedLongs;
import scouter.util.zipkin.HexCodec;

public class Hexa32 {
    private static final char PLUS = 'x';
    private static final char MINUS = 'z';
    private static final String min = "z8000000000000";

    public static String toUnsignedLongHex(long num) {
        return UnsignedLongs.toString(num, 16);
    }

    public static long fromUnsignedLongHex(String str) {
        return UnsignedLongs.parseUnsignedLong(str, 16);
    }

    public static String toString32(long num) {
        boolean minus;
        boolean bl = minus = num < 0L;
        if (minus) {
            if (num == Long.MIN_VALUE) {
                return min;
            }
            return 'z' + Long.toString(-num, 32);
        }
        if (num < 10L) {
            return Long.toString(num);
        }
        return 'x' + Long.toString(num, 32);
    }

    public static long toLong32(String str) {
        if (str == null || str.length() == 0) {
            return 0L;
        }
        switch (str.charAt(0)) {
            case 'z': {
                if (min.equals(str)) {
                    return Long.MIN_VALUE;
                }
                return -1L * Long.parseLong(str.substring(1), 32);
            }
            case 'x': {
                return Long.parseLong(str.substring(1), 32);
            }
        }
        return Long.parseLong(str);
    }

    public static void main(String[] args) {
        System.out.println(Hexa32.toString32(0xAFFAAAAAAAAAAAAL));
        System.out.println(Hexa32.toString32(-342343233040343034L));
        System.out.println(Hexa32.toLong32("z6eq8mqkdkpt7c"));
        System.out.println(Hexa32.toString32(100000001L));
        System.out.println(Long.toHexString(0xAFFAAAAAAAAAAAAL));
        System.out.println("=================================================");
        System.out.println(Long.toHexString(-342343233040343034L));
        System.out.println(UnsignedLongs.toString(-342343233040343034L, 16));
        System.out.println(UnsignedLongs.parseUnsignedLong("fb3fc0a4b35f2006", 16));
        System.out.println("=================================================");
        System.out.println(HexCodec.lowerHexToUnsignedLong("fb3fc0a4b35f2006"));
    }
}

