/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.Map;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.asm.JDBCDriverCV;
import scouter.agent.asm.util.AsmUtil;
import scouter.agent.asm.util.HookingSet;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class JDBCDriverASM
implements IASM,
Opcodes {
    private Map<String, HookingSet> reserved;

    public JDBCDriverASM() {
        this.reserved = HookingSet.getHookingSet(Configure.getInstance().hook_jdbc_wrapping_driver_patterns);
        AsmUtil.add(this.reserved, "com/ibm/db2/jcc/DB2Driver", "connect(Ljava/lang/String;Ljava/util/Properties;)Ljava/sql/Connection;");
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!Configure.getInstance()._hook_dbconn_enabled) {
            return cv;
        }
        HookingSet mset = this.reserved.get(className);
        if (mset != null) {
            return new JDBCDriverCV(cv, mset, className);
        }
        return cv;
    }
}

