/*
 * Decompiled with CFR 0.152.
 */
package scouter.agent.asm;

import java.util.HashSet;
import java.util.Set;
import scouter.agent.ClassDesc;
import scouter.agent.Configure;
import scouter.agent.asm.IASM;
import scouter.agent.asm.SpringReqMapCV;
import scouter.org.objectweb.asm.ClassVisitor;
import scouter.org.objectweb.asm.Opcodes;

public class SpringReqMapASM
implements IASM,
Opcodes {
    static String[] springControllerNames = new String[]{"Lorg/springframework/stereotype/Controller;", "Lorg/springframework/web/bind/annotation/RestController;"};
    static Set<String> springRequestMappingAnnotations = new HashSet<String>();
    Configure conf = Configure.getInstance();

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!this.conf._hook_spring_rest_enabled) {
            return cv;
        }
        if (classDesc.annotation != null) {
            for (int i = 0; i < springControllerNames.length; ++i) {
                if (!classDesc.annotation.contains(springControllerNames[i])) continue;
                return new SpringReqMapCV(cv, className);
            }
        }
        return cv;
    }

    static {
        springRequestMappingAnnotations.add("Lorg/springframework/web/bind/annotation/RequestMapping;");
        springRequestMappingAnnotations.add("Lorg/springframework/web/bind/annotation/GetMapping;");
        springRequestMappingAnnotations.add("Lorg/springframework/web/bind/annotation/PostMapping;");
        springRequestMappingAnnotations.add("Lorg/springframework/web/bind/annotation/PutMapping;");
        springRequestMappingAnnotations.add("Lorg/springframework/web/bind/annotation/DeleteMapping;");
        springRequestMappingAnnotations.add("Lorg/springframework/web/bind/annotation/PatchMapping;");
    }
}

